// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "CsdkInitAction.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FCsdkInitResult,const int32, ErrorCode,const FString&, ErrorMsg);

/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkInitAction : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 聊天SDK初始化
	 * @param WorldContextObject UObject上下文
	 * @param ProductId 产品Id
	 * @param ProductKey 产品Key
	 * @param Url 服务器地址
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Init")
	static UCsdkInitAction* CsdkInit(UObject* WorldContextObject,const FString& ProductId,const FString& ProductKey,const FString& Url);

	/**
	 * @brief 聊天SDK反初始化
	 */
	UFUNCTION(BlueprintCallable, Category = "CSDK|Init")
	static void CsdkDeinit();

	/** Execute the actual operation */
	virtual void Activate() override;

	/**
	 * @brief 初始化回调
	 */
	UPROPERTY(BlueprintAssignable)
	FCsdkInitResult Completed;

private:
	FString ProductId;
	FString ProductKey;
	FString Url;
};
