﻿// Copyright Epic Games, Inc. All Rights Reserved.

#pragma once

#include "CoreTypes.h" 
#include "CoreMinimal.h"
#include "CsdkLogSingleton.h"
#include "Logging/LogMacros.h"
#include "Setting/CsdkLogSettings.h"



#define CSDK_LOG(CategoryName, Verbosity, Format, ...) \
{ \
	if(UCsdkLogSettings::Get() && UCsdkLogSettings::Get()->bUseCsdkLog)\
	{\
		static_assert(TIsArrayOrRefOfType<decltype(Format), TCHAR>::Value, "Formatting string must be a TCHAR array."); \
		static_assert((ELogVerbosity::Verbosity & ELogVerbosity::VerbosityMask) < ELogVerbosity::NumVerbosity && ELogVerbosity::Verbosity > 0, "Verbosity must be constant and in range."); \
		CsdkLogSingleton::GetInst().Logf(#CategoryName,ELogVerbosity::Verbosity,Format, ##__VA_ARGS__); \
	}\
	if(UCsdkLogSettings::Get() && UCsdkLogSettings::Get()->bUseUeLog)\
	{\
		UE_LOG(CategoryName, Verbosity, Format, ##__VA_ARGS__) \
	}\
}
