// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"

/**
 * 
 */
class CSDKRUNTIME_API CsdkLogSingleton
{
public:
	CsdkLogSingleton();
	static CsdkLogSingleton& GetInst();
	
	
	template <typename FmtType, typename... Types>
void Logf(const FName& Category, ELogVerbosity::Type Verbosity, const FmtType& Fmt, Types... Args)
	{
		static_assert(TAnd<TIsValidVariadicFunctionArg<Types>...>::Value, "Invalid argument(s) passed to FMsg::Logf");

		LogfImpl(Category, Verbosity, Fmt, Args...);
	}
private:
	void VARARGS LogfImpl(const FName& Category, ELogVerbosity::Type Verbosity, const TCHAR* Fmt, ...) const;
	TSharedPtr<class ICsdkTrace> LogTracer = nullptr;
};
