// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "User/Data/CsdkUser.h"
#include "CsdkUserLogin.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FCsdkUserLoginCallBack,const int32,ErrorCode, const FString&, ErrorMsg);

/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkUserLogin : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 聊天用户登录
	 * @param WorldContextObject 上下文
	 * @param User 登录用户信息
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Login")
	static UCsdkUserLogin* CsdkUserLogin(UObject* WorldContextObject,const FCsdkUser& User);

	virtual void Activate() override;
	
	/**
	 * @brief 登录回调
	 */
	UPROPERTY(BlueprintAssignable)
	FCsdkUserLoginCallBack Completed;

private:
	FCsdkUser User;
};
