﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "CsdkMessageBase.h"
#include "CsdkTextMessage.generated.h"

DECLARE_DYNAMIC_DELEGATE_TwoParams(FTranslateCallback, const int32, ErrorCode, const FString&, ErrorMsg);

/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkTextMessage : public UCsdkMessageBase
{
	GENERATED_BODY()
public:
	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category= "Csdk|Message")
	FString Content;
	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category= "Csdk|Message")
	FString TranslatedContent;
	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category= "Csdk|Message")
	FString SourceLanguage;
	
	UFUNCTION(BlueprintCallable, Category= "Csdk|Message")
	void Translate(const FString& SourceLang,const FString& TargetLang,const FTranslateCallback& Callback);
};

