// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Core/CsdkCustomMessage.h"
#include "Core/CsdkMessageBase.h"
#include "Core/CsdkVoiceMessage.h"
#include "Kismet/BlueprintFunctionLibrary.h"
#include "CsdkMessageLibrary.generated.h"

/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkMessageLibrary final : public UBlueprintFunctionLibrary 
{
	GENERATED_BODY()
public:

	/**
	 * @brief 创建一个待发送的客户端文本消息
	 * @param Content 文本内容
	 * @param Extra 扩展字段
	 * @return 文本消息
	 */
	UFUNCTION(BlueprintCallable,Category = "CSDK|Message")
	static UCsdkTextMessage* NewTextMsg(const FString& Content, const TMap<FString, FString>& Extra);
	/**
	 * @brief 创建一个待发送的客户端语音消息
	 * @param Url 语音文件Url
	 * @param Duration 语音时长
	 * @param Title 用于敏感词检查的字段
	 * @param Extra 扩展字段
	 * @return 语音消息
	 */
	UFUNCTION(BlueprintCallable,Category = "CSDK|Message")
	static UCsdkVoiceMessage* NewVoiceMsg(const FString& Url, const float Duration, const FString& Title, const TMap<FString, FString>& Extra);
	/**
	 * @brief 创建一个待发送的客户端语音消息
	 * @param Title 用于敏感词检查的字段
	 * @param Data 自定义字符串
	 * @param Extra 扩展字段
	 * @return 自定义消息
	 */
	UFUNCTION(BlueprintCallable,Category = "CSDK|Message")
	static UCsdkCustomMessage* NewCustomMsg( const FString& Content, const TMap<FString, FString>& Extra);
private:
	static void FillMsg(UCsdkMessageBase* Message,const TMap<FString, FString>& Extra);
};

