// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Core/CsdkMessageBase.h"
#include "Data/CsdkMsgPullDirection.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "Session/Data/CsdkSessionId.h"
#include "CsdkPullMsg.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_FourParams(FCsdkPullMsgResult,const int32, ErrorCode ,const FString&,ErrorMsg,const FCsdkSessionId&, SessionId, const TArray<UCsdkMessageBase*>&, Messages);
/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkPullMsg : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 拉取消息
	 * @param WorldContextObject 上下文
	 * @param SessionId 会话ID
	 * @param AnchorMsgId 锚点消息ID，如拉取最新消息，则为空
	 * @param DesiredPullCount 期望拉取数量
	 * @param Direction 方向
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Message")
	static UCsdkPullMsg* PullMsg(UObject* WorldContextObject, const FCsdkSessionId& SessionId, const FString& AnchorMsgId, const int32 DesiredPullCount = 30,
	                             const ECsdkMsgPullDirection Direction = ECsdkMsgPullDirection::Forward);

	virtual void Activate() override;
	UPROPERTY(BlueprintAssignable)
	FCsdkPullMsgResult Completed;
private:
	FCsdkSessionId SessionId;
	FString AnchorMsgId;
	int32 DesiredPullCount = 0;
	ECsdkMsgPullDirection Direction = ECsdkMsgPullDirection::Forward; 
};
