// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "Session/Data/CsdkSessionId.h"
#include "CsdkSendMsg.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FCsdkSendMsgResult,const int32, ErrorCode, const FString&, ErrorMsg);
/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkSendMsg : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 发送消息到服务器
	 * @param WorldContextObject 上下文
	 * @param SessionId 会话ID
	 * @param CsdkMessage 消息对象
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Message|Send")
	static UCsdkSendMsg* SendMsg(UObject* WorldContextObject, const FCsdkSessionId& SessionId,UCsdkMessageBase* CsdkMessage);
	virtual void Activate() override;
	
	UPROPERTY(BlueprintAssignable)
	FCsdkSendMsgResult Completed;

private:
	FCsdkSessionId SessionId;
	UPROPERTY()
	TObjectPtr<UCsdkMessageBase> CsdkMessage;
};
