// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "User/Data/CsdkUserId.h"
#include "CsdkAddBlock.generated.h"


DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FCsdkAddBlockResult,const int32,ErrorCode,const FString&,ErrorMsg);

/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkAddBlock : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 拉黑用户
	 * @param WorldContextObject 
	 * @param UserId 用户ID
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Relationship")
		static UCsdkAddBlock* AddBlock(UObject* WorldContextObject, const FCsdkUserId& UserId);

	/** Execute the actual operation */
	virtual void Activate() override;

	UPROPERTY(BlueprintAssignable)
	FCsdkAddBlockResult Completed;
private:
	FCsdkUserId UserId;

};
