// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "User/Data/CsdkUserId.h"
#include "CsdkRemoveBlock.generated.h"


DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FCsdkRemoveBlockResult,const int32,ErrorCode,const FString&,ErrorMsg);

/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkRemoveBlock : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 取消拉黑
	 * @param WorldContextObject 
	 * @param UserId 用户ID
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Relationship")
		static UCsdkRemoveBlock* RemoveBlock(UObject* WorldContextObject, const FCsdkUserId& UserId);

	/** Execute the actual operation */
	virtual void Activate() override;

	UPROPERTY(BlueprintAssignable)
	FCsdkRemoveBlockResult Completed;
private:
	FCsdkUserId UserId;

};
