// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "Data/CsdkOperateFriendApplyResult.h"
#include "CsdkFriendListApplyOperate.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_ThreeParams(FCsdkFriendListApplyOperateCallback,const int32,ErrorCode,const FString&,ErrorMsg ,const TArray<FCsdkOperateFriendApplyResult>&, ApplyResults);


/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkFriendListApplyOperate : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 批量同意好友申请
	 * @param WorldContextObject 
	 * @param Tokens 好友申请记录号
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Relationship|FriendApply")
	static UCsdkFriendListApplyOperate* AgreeFriendListApply(UObject* WorldContextObject, const TArray<FString>& Tokens);
 
	/**
	 * @brief 批量拒绝好友申请
	 * @param WorldContextObject 
	 * @param Tokens 好友申请记录号
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Relationship|FriendApply")
	static UCsdkFriendListApplyOperate* RefuseFriendListApply(UObject* WorldContextObject,const TArray<FString>& Tokens);
	
	UPROPERTY(BlueprintAssignable)
	FCsdkFriendListApplyOperateCallback Completed;
	
};

