// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Data/CsdkFriendApply.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "CsdkGetFriendApplyList.generated.h"


DECLARE_DYNAMIC_MULTICAST_DELEGATE_ThreeParams(FCsdkGetFriendApplyListResult,const int32,ErrorCode,const FString&,ErrorMsg, const TArray<FCsdkFriendApply>&, ApplyList);

/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkGetFriendApplyList : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 获取好友申请列表
	 * @param WorldContextObject 上下文
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Relationship|FriendApply")
		static UCsdkGetFriendApplyList* GetFriendApplyList(UObject* WorldContextObject);

	UPROPERTY(BlueprintAssignable)
	FCsdkGetFriendApplyListResult Completed;
};

