// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "User/Data/CsdkUserId.h"
#include "CsdkOperateFriend.generated.h"


DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FCsdkOperateFriendResult,const int32,ErrorCode,const FString&,ErrorMsg);

/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkOperateFriend : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 添加好友
	 * @param WorldContextObject 
	 * @param UserId 用户Id
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Relationship|Friend")
	static UCsdkOperateFriend* AddFriend(UObject* WorldContextObject,const FCsdkUserId& UserId);

	/**
	 * @brief 删除好友
	 * @param WorldContextObject 
	 * @param UserId 用户Id
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Relationship|Friend")
	static UCsdkOperateFriend* DeleteFriend(UObject* WorldContextObject,const FCsdkUserId& UserId);
	
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Relationship|Friend")
	static UCsdkOperateFriend* UpdateFriendInfo(UObject* WorldContextObject,const FCsdkUserId& UserId, const TMap<FString, FString>& UserInfoExtra);
	
	UPROPERTY(BlueprintAssignable)
	FCsdkOperateFriendResult Completed;

};
