// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "Session/Data/CsdkSessionId.h"
#include "CsdkPinSession.generated.h"


DECLARE_DYNAMIC_MULTICAST_DELEGATE_ThreeParams(FCsdkPinSessionResult, const int32, ErrorCode, const FString&, ErrorMsg,const FDateTime&, DateTime/*置顶时间*/);

/**#
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkPinSession : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 置顶会话
	 * @param WorldContextObject 
	 * @param SessionId 会话ID
	 * @param bIsPinned 是否置顶
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Session")
	static UCsdkPinSession* PinSession(UObject* WorldContextObject,const FCsdkSessionId& SessionId,const bool bIsPinned);
	
	virtual void Activate() override;
	
	UPROPERTY(BlueprintAssignable)
	FCsdkPinSessionResult Completed;
	
private:
	FCsdkSessionId MySessionId;
	bool bMyIsPinned = false;
};


