﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "CsdkSessionId.h"
#include "UObject/Object.h"
#include "Message/Core/CsdkMessageBase.h"
#include "CsdkSession.generated.h"

/**
 * 
 */
UCLASS(BlueprintType)
class CSDKRUNTIME_API UCsdkSession : public UObject
{
	GENERATED_BODY()

public:
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|Session")
	FCsdkSessionId SessionId;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|Session")
	FDateTime UpdateTime;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|Session")
	TObjectPtr<UCsdkMessageBase> LastMsg = nullptr;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|Session")
	bool bIsPinned = false;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|Session")
	FDateTime PinnedTime;
};
