﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "JsonObjectConverter.h"
#include "CsdkSessionType.h"
#include "CsdkSessionId.generated.h"

/*
 *
 */
USTRUCT(BlueprintType)
struct FCsdkSessionId
{
	GENERATED_BODY()
	
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|Session")
	FString ReceiverId;
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|Session")
	FString ServerId;
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|Session")
	TEnumAsByte<ECsdkSessionType::Type>  Type = ECsdkSessionType::Invalid;

	
	bool operator==(const FCsdkSessionId& Other) const
	{
		if(Type == ECsdkSessionType::Custom && Other.Type == ECsdkSessionType::Custom)
		{
			return this->ReceiverId==Other.ReceiverId;
		}
		
		return this->Type ==Other.Type && this->ReceiverId==Other.ReceiverId && this->ServerId==Other.ServerId;
	}

	bool IsValid() const 
	{
		return Type !=ECsdkSessionType::Invalid && !ReceiverId.IsEmpty() && !ServerId.IsEmpty();
	}

	FString ToString() const
	{
		FString Result;
		FJsonObjectConverter::UStructToJsonObjectString(*this,Result);
		return Result;
	}
};

FORCEINLINE uint32 GetTypeHash(const FCsdkSessionId& S)
{
	const auto Str = S.ReceiverId + TEXT(":")+ S.ServerId +TEXT(":")+FString::FromInt(static_cast<int32>(S.Type)) ;
	return FCrc::Strihash_DEPRECATED(Str.Len(), *Str);
}

