// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "CsdkTranslateAction.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_FourParams(FCsdkTranslateResult, const int32, ErrorCode, const FString&, ErrorMsg,
                                            const FString&, Content, const FString&, SourceLanguage);

/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkTranslateAction : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()

public:
	/**
	 * @brief 翻译
	 * @param WorldContextObject 
	 * @param Content 待翻译内容
	 * @param SourceLanguage 源语言
	 * @param TargetLanguage 目标语言
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"),Category = "CSDK|Translate")
	static UCsdkTranslateAction* Translate(UObject* WorldContextObject, const FString& Content,
	                                       const FString& SourceLanguage, const FString& TargetLanguage);

	/** Execute the actual operation */
	virtual void Activate() override;

	UPROPERTY(BlueprintAssignable)
	FCsdkTranslateResult Completed;

private:
	FString Content;
	FString SourceLanguage;
	FString TargetLanguage;
};
