﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Data/CsdkUser.h"
#include "Data/CsdkUserId.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "CsdkGetUser.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_ThreeParams(FCsdkGetUserResult,const int32, ErrorCode, const FString&, ErrorMsg,
                                               const FCsdkUser&, UserInfo);

UCLASS()
class CSDKRUNTIME_API UCsdkGetUser : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 获取用户资料信息
	 * @param WorldContextObject 上下文
	 * @param UserId 用户Id
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"),Category = "CSDK|User")
	static UCsdkGetUser* GetUserInfo(UObject* WorldContextObject, const FCsdkUserId& UserId);

	virtual void Activate() override;

	UPROPERTY(BlueprintAssignable)
	FCsdkGetUserResult Completed;

private:
	FCsdkUserId UserId;
};
