﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Data/CsdkUser.h"
#include "Data/CsdkUserId.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "CsdkGetUserList.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_ThreeParams(FCsdkGetUserListResult,const int32, ErrorCode, const FString&, ErrorMsg,
                                               const TArray<FCsdkUser>&, UserInfoList);

UCLASS()
class CSDKRUNTIME_API UCsdkGetUserList : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	
	/**
	 * @brief 根据用户ID，批量获取用户数据
	 * @param WorldContextObject 
	 * @param UserIdList 用户Id数组
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"),
		Category = "CSDK|User")
	static UCsdkGetUserList* GetUserList(UObject* WorldContextObject, const TArray<FCsdkUserId>& UserIdList);

	virtual void Activate() override;

	UPROPERTY(BlueprintAssignable)
	FCsdkGetUserListResult Completed;

private:
	TArray<FCsdkUserId> UserIdList;
};
