﻿#pragma once
#include "Data/CsdkUserStatus.h"
#include "CoreMinimal.h"
#include "Data/CsdkUserId.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "CsdkGetUserStatus.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_ThreeParams(FCsdkGetUserStatusResult, const int32, ErrorCode, const FString&, ErrorMsg,
											   const FCsdkUserStatusResult&, StatusResult);

UCLASS()
class CSDKRUNTIME_API UCsdkGetUserStatus : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"),
		Category = "CSDK|User")
	static UCsdkGetUserStatus* GetUserStatus(UObject* WorldContextObject,const FCsdkUserId& UserId);

	virtual void Activate() override;

	UPROPERTY(BlueprintAssignable)
	FCsdkGetUserStatusResult Completed;

private:
	FCsdkUserId UserId;
};
