﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Data/CsdkUser.h"
#include "Data/CsdkUserSearch.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "CsdkSearchUser.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_ThreeParams(FCsdkSearchUserResult, const int32, ErrorCode, const FString&, ErrorMsg, const TArray<FCsdkUser>&, UserList);

UCLASS()
class CSDKRUNTIME_API UCsdkSearchUser : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 搜索用户
	 * @param WorldContextObject 
	 * @param Conditions 搜索条件
	 * @param PageNo 分页
	 * @param PageSize 分页数量
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|User")
	static UCsdkSearchUser* SearchUser(UObject* WorldContextObject, const TArray<FCsdkUserSearchCondition>& Conditions, const int32 PageNo, const int32 PageSize);
	virtual void Activate() override;

	UPROPERTY(BlueprintAssignable)
	FCsdkSearchUserResult Completed;

private:
	TArray<FCsdkUserSearchCondition> Conditions;
	int32 PageNo;
	int32 PageSize;
};


