// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Data/CsdkUser.h"
#include "Kismet/BlueprintFunctionLibrary.h"
#include "CsdkUserLibrary.generated.h"

/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkUserLibrary final : public UBlueprintFunctionLibrary 
{
	GENERATED_BODY()
public:
	/**
	 * @brief 获取当前用户信息
	 * @return 
	 */
	UFUNCTION(BlueprintPure, Category = "CSDK|User")
	static FCsdkUser GetCurrentUser();
	UFUNCTION(BlueprintPure, Category = "CSDK|User")
	static FString GetCsdkServerId();
	UFUNCTION(BlueprintPure, Category = "CSDK|User", meta = (DisplayName = "ToString(UserId)", CompactNodeTitle = "->", BlueprintAutocast))
	static FString Conv_UserIdToString( const FCsdkUserId& UserId);
	UFUNCTION(BlueprintPure, Category = "CSDK|User", meta = (DisplayName = "ToString(User)", CompactNodeTitle = "->", BlueprintAutocast))
	static FString Conv_UserToString( const FCsdkUser& User);

	UFUNCTION(BlueprintPure, meta=(DisplayName = "Equal CsdkUserId", CompactNodeTitle = "==", Keywords = "== equal"), Category="CSDK|User")
	static bool Equal_FCsdkUserId(const FCsdkUserId& A, const FCsdkUserId& B)
	{
		return A == B;
	}

};
