/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.impl;

import com.gme.TMG.ITMGAudioCtrl;
import com.gme.TMG.ITMGType;
import com.gme.av.jni.GMESDKAudioJni;

public class TMGAudioCtrl
extends ITMGAudioCtrl {
    public static final String TAG = TMGAudioCtrl.class.getSimpleName();
    private final GMESDKAudioJni mNativeAudioJni;

    TMGAudioCtrl(GMESDKAudioJni nativeAudioJni) {
        this.mNativeAudioJni = nativeAudioJni;
    }

    @Override
    public int EnableMic(boolean isEnabled) {
        int n2 = this.EnableAudioCaptureDevice(isEnabled);
        int n3 = this.EnableAudioSend(isEnabled);
        if (n2 == 0 && n3 == 0) {
            return 0;
        }
        if (n2 != 0) {
            return n2;
        }
        return n3;
    }

    @Override
    public int GetMicState() {
        if (this.IsAudioCaptureDeviceEnabled() && this.IsAudioSendEnabled()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int EnableSpeaker(boolean isEnabled) {
        int n2 = this.EnableAudioPlayDevice(isEnabled);
        int n3 = this.EnableAudioRecv(isEnabled);
        if (n2 == 0 && n3 == 0) {
            return 0;
        }
        if (n2 != 0) {
            return n2;
        }
        return n3;
    }

    @Override
    public int GetSpeakerState() {
        if (this.IsAudioPlayDeviceEnabled() && this.IsAudioRecvEnabled()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int EnableAudioCaptureDevice(boolean isEnabled) {
        return this.mNativeAudioJni.enableAudioCaptureDevice(isEnabled);
    }

    @Override
    public boolean IsAudioCaptureDeviceEnabled() {
        return this.mNativeAudioJni.isAudioCaptureDeviceEnabled();
    }

    @Override
    public int EnableAudioPlayDevice(boolean isEnabled) {
        return this.mNativeAudioJni.enableAudioPlayDevice(isEnabled);
    }

    @Override
    public boolean IsAudioPlayDeviceEnabled() {
        return this.mNativeAudioJni.isAudioPlayDeviceEnabled();
    }

    @Override
    public int GetSpeakerVolumeByUserID(String userID) {
        return this.mNativeAudioJni.getSpeakerVolumeByUserID(userID);
    }

    @Override
    public int EnableAudioSend(boolean isEnabled) {
        return this.mNativeAudioJni.enableAudioSend(isEnabled);
    }

    @Override
    public int SetSpeakerVolumeByUserID(String userID, int volume) {
        return this.mNativeAudioJni.setSpeakerVolumeByUserID(userID, volume);
    }

    @Override
    public boolean IsAudioSendEnabled() {
        return this.mNativeAudioJni.isAudioSendEnabled();
    }

    @Override
    public int EnableAudioRecv(boolean isEnabled) {
        return this.mNativeAudioJni.enableAudioRecv(isEnabled);
    }

    @Override
    public boolean IsAudioRecvEnabled() {
        return this.mNativeAudioJni.isAudioRecvEnabled();
    }

    @Override
    public int GetMicVolume() {
        return this.mNativeAudioJni.getMicVolume();
    }

    @Override
    public int SetMicVolume(int volume) {
        return this.mNativeAudioJni.setMicVolume(volume);
    }

    @Override
    public int GetSpeakerVolume() {
        return this.mNativeAudioJni.getSpeakerVolume();
    }

    @Override
    public int SetSpeakerVolume(int volume) {
        return this.mNativeAudioJni.setSpeakerVolume(volume);
    }

    @Override
    public int EnableLoopBack(boolean enable) {
        return this.mNativeAudioJni.enableLoopBack(enable);
    }

    @Override
    public int AddAudioBlackList(String userID) {
        return this.mNativeAudioJni.addAudioBlackList(userID);
    }

    @Override
    public int RemoveAudioBlackList(String userID) {
        return this.mNativeAudioJni.removeAudioBlackList(userID);
    }

    @Override
    public boolean IsUserIDInAudioBlackList(String userID) {
        return this.mNativeAudioJni.isUserIDInAudioBlackList(userID);
    }

    @Override
    public int EnableCustomAudioCapture(boolean enable) {
        return this.mNativeAudioJni.EnableCustomAudioCapture(enable);
    }

    @Override
    public int SetAudioRoute(ITMGType.ITMG_AUDIO_ROUTE route) {
        return this.mNativeAudioJni.SetAudioRoute(route.getNativeValue());
    }

    @Override
    public int SendCustomAudioData(ITMGType.TMGAudioFrame frame) {
        return this.mNativeAudioJni.SendCustomAudioData(frame);
    }

    @Override
    public int EnableCustomAudioRendering(boolean enable) {
        return this.mNativeAudioJni.EnableCustomAudioRendering(enable);
    }

    @Override
    public int GetCustomAudioRenderingFrame(ITMGType.TMGAudioFrame frame) {
        return this.mNativeAudioJni.GetCustomAudioRenderingFrame(frame);
    }

    @Override
    public int TrackingVolume(float interval) {
        return this.mNativeAudioJni.TrackingVolume(interval);
    }

    @Override
    public int StopTrackingVolume() {
        return this.mNativeAudioJni.StopTrackingVolume();
    }

    @Override
    public int GetMicLevel() {
        return this.mNativeAudioJni.GetMicLevel();
    }

    @Override
    public int GetSpeakerLevel() {
        return this.mNativeAudioJni.GetSpeakerLevel();
    }

    @Override
    public int GetSendStreamLevel() {
        return this.mNativeAudioJni.GetSendStreamLevel();
    }

    @Override
    public int GetRecvStreamLevel(String userID) {
        return this.mNativeAudioJni.GetRecvStreamLevel(userID);
    }

    @Override
    public int InitSpatializer(String modelPath) {
        return this.mNativeAudioJni.InitSpatializer(modelPath);
    }

    @Override
    public int EnableSpatializer(boolean enable) {
        return this.mNativeAudioJni.EnableSpatializer(enable);
    }

    @Override
    public boolean IsEnableSpatializer() {
        return this.mNativeAudioJni.IsEnableSpatializer();
    }

    @Override
    public void SetAudioFrameCallback(ITMGAudioCtrl.ITMGAudioFrameCallback callback) {
        this.mNativeAudioJni.setAudioFrameCallback(callback);
    }
}

