/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.impl;

import android.app.Activity;
import android.content.Context;
import com.gme.TMG.ITMGAudioCtrl;
import com.gme.TMG.ITMGAudioEffectCtrl;
import com.gme.TMG.ITMGContext;
import com.gme.TMG.ITMGPTT;
import com.gme.TMG.ITMGRoom;
import com.gme.TMG.ITMGType;
import com.gme.av.impl.TMGAudioCtrl;
import com.gme.av.impl.TMGAudioEffectCtrl;
import com.gme.av.impl.TMGPTT;
import com.gme.av.impl.TMGRoom;
import com.gme.av.jni.GMESDKJni;
import com.gme.av.utils.QLog;
import com.gme.liteav.base.ContextUtils;
import com.gme.liteav.base.util.e;

public class TMGContext
extends ITMGContext {
    public static final String TAG = TMGContext.class.getSimpleName();
    private GMESDKJni mNativeSDKJni;
    private TMGRoom mRoom;
    private TMGAudioCtrl mAudioCtrl;
    private TMGAudioEffectCtrl mAudioEffectCtrl;
    private TMGPTT mPTT;
    private Context mContext;
    private ITMGContext.ITMGDelegate mDelegate;

    public TMGContext(Context context) {
        this.mContext = context == null ? null : context.getApplicationContext();
        ContextUtils.initApplicationContext(this.mContext);
        ContextUtils.setDataDirectorySuffix("gme");
        this.initCloud();
        if (context instanceof Activity) {
            e.a().a((Activity)context);
        }
    }

    private void initCloud() {
        this.mNativeSDKJni = new GMESDKJni();
        this.mRoom = new TMGRoom(this.mNativeSDKJni.getRoomJni());
        this.mAudioCtrl = new TMGAudioCtrl(this.mNativeSDKJni.getAudioJni());
        this.mAudioEffectCtrl = new TMGAudioEffectCtrl(this.mNativeSDKJni.getAudioEffectJni());
        this.mPTT = new TMGPTT(this.mNativeSDKJni.getPTTJni());
    }

    @Override
    public int Poll() {
        return this.mNativeSDKJni.poll();
    }

    @Override
    public int Pause() {
        return this.mNativeSDKJni.pause();
    }

    @Override
    public int Resume() {
        return this.mNativeSDKJni.resume();
    }

    @Override
    public int SetLogLevel(ITMGType.ITMG_LOG_LEVEL levelWrite, ITMGType.ITMG_LOG_LEVEL levelPrint) {
        return this.mNativeSDKJni.setLogLevel(levelWrite.getNativeValue(), levelPrint.getNativeValue());
    }

    @Override
    public int SetLogPath(String logPath) {
        return this.mNativeSDKJni.setLogPath(logPath);
    }

    @Override
    public String GetLogPath() {
        return this.mNativeSDKJni.getLogPath();
    }

    @Override
    public void SetRegion(String region) {
        this.mNativeSDKJni.setRegion(region);
    }

    @Override
    public int Init(String appId, String userId) {
        return this.mNativeSDKJni.init(appId, userId);
    }

    @Override
    public int Uninit() {
        return this.mNativeSDKJni.unInit();
    }

    @Override
    public int ShowDebugView(boolean enable) {
        return this.mNativeSDKJni.showDebugView(enable);
    }

    @Override
    public int SetTMGDelegate(ITMGContext.ITMGDelegate delegate) {
        QLog.i(TAG, String.format("SetTMGDelegate.delegate=%s", delegate));
        this.mDelegate = delegate;
        if (this.mNativeSDKJni != null) {
            this.mNativeSDKJni.setDelegate(this.mDelegate);
        }
        return 0;
    }

    @Override
    public ITMGRoom GetRoom() {
        return this.mRoom;
    }

    @Override
    public ITMGAudioCtrl GetAudioCtrl() {
        return this.mAudioCtrl;
    }

    @Override
    public ITMGAudioEffectCtrl GetAudioEffectCtrl() {
        return this.mAudioEffectCtrl;
    }

    @Override
    public ITMGPTT GetPTT() {
        return this.mPTT;
    }

    @Override
    public String GetSDKVersion() {
        return this.mNativeSDKJni.getSDKVersion();
    }

    @Override
    public void SetAppVersion(String appVersion) {
        this.mNativeSDKJni.setAppVersion(appVersion);
    }

    @Override
    public int SetScene(ITMGType.ITMG_APP_SCENE scene) {
        return this.mNativeSDKJni.setScene(scene.getNativeValue());
    }

    @Override
    public int SetAdvanceParams(String strKey, String strValue) {
        return this.mNativeSDKJni.setAdvanceParams(strKey, strValue);
    }

    @Override
    public String GetAdvanceParams(String strKey) {
        return this.mNativeSDKJni.getAdvanceParam(strKey);
    }

    @Override
    public int EnterRoom(String roomId, ITMGType.ITMG_ROOM_TYPE roomType, byte[] userSig) {
        return this.mNativeSDKJni.enterRoom(roomId, roomType.getNativeValue(), userSig);
    }

    @Override
    public int ExitRoom() {
        return this.mNativeSDKJni.exitRoom();
    }

    @Override
    public boolean IsRoomEntered() {
        return this.mNativeSDKJni.isRoomEntered();
    }

    @Override
    public int SetAudioRole(ITMGType.ITMG_AUDIO_MEMBER_ROLE role) {
        return this.mNativeSDKJni.setAudioRole(role.getNativeValue());
    }

    @Override
    public int SetRangeAudioMode(ITMGType.ITMG_RANGE_AUDIO_MODE rangeAudioMode) {
        return this.mNativeSDKJni.setRangeAudioMode(rangeAudioMode.getNativeValue());
    }

    @Override
    public int SetRangeAudioTeamID(int teamID) {
        return this.mNativeSDKJni.setRangeAudioTeamID(teamID);
    }

    @Override
    public int SetRecvMixStreamCount(int count) {
        return this.mNativeSDKJni.setRecvMixStreamCount(count);
    }

    @Override
    public ITMGType.ITMG_MIC_PERMISSION CheckMicPermission() {
        return ITMGType.ITMG_MIC_PERMISSION.values()[this.mNativeSDKJni.checkMicPermission()];
    }
}

