/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.jni;

import com.gme.liteav.base.annotations.JNINamespace;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@JNINamespace(value="liteav::gme")
public class GMESDKAudioEffectJni {
    private final ReentrantReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock mJniReadLock = this.mReadWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock mJniWriteLock = this.mReadWriteLock.writeLock();
    private long mNativeGMESDKAudioEffectJni;

    public GMESDKAudioEffectJni(long nativeGMESDKAudioEffectJni) {
        this.mNativeGMESDKAudioEffectJni = nativeGMESDKAudioEffectJni;
    }

    public int destroy() {
        this.mJniWriteLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeDestroy(this.mNativeGMESDKAudioEffectJni);
                this.mNativeGMESDKAudioEffectJni = 0L;
                return n2;
            }
        }
        finally {
            this.mJniWriteLock.unlock();
        }
        return 1101;
    }

    public int setMusicPitch(long soundId, float pitch) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeSetMusicPitch(this.mNativeGMESDKAudioEffectJni, soundId, pitch);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int startPlayMusic(long soundId, String filePath, int loopCount) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeStartPlayMusic(this.mNativeGMESDKAudioEffectJni, soundId, filePath, loopCount);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int pausePlayMusic(long soundId) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativePausePlayMusic(this.mNativeGMESDKAudioEffectJni, soundId);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int resumePlayMusic(long soundId) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeResumePlayMusic(this.mNativeGMESDKAudioEffectJni, soundId);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int stopPlayMusic(long soundId) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeStopPlayMusic(this.mNativeGMESDKAudioEffectJni, soundId);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public boolean isMusicPlayEnd(long soundId) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                boolean bl = GMESDKAudioEffectJni.nativeIsMusicPlayEnd(this.mNativeGMESDKAudioEffectJni, soundId);
                return bl;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return true;
    }

    public int setMusicPublishVolume(long soundId, int volume) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeSetMusicPublishVolume(this.mNativeGMESDKAudioEffectJni, soundId, volume);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int getMusicPublishVolume(long soundId) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeGetMusicPublishVolume(this.mNativeGMESDKAudioEffectJni, soundId);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int setMusicPlayoutVolume(long soundId, int volume) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeSetMusicPlayoutVolume(this.mNativeGMESDKAudioEffectJni, soundId, volume);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int getMusicPlayoutVolume(long soundId) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeGetMusicPlayoutVolume(this.mNativeGMESDKAudioEffectJni, soundId);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int getMusicDurationInMS(long soundId) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeGetMusicDurationInMS(this.mNativeGMESDKAudioEffectJni, soundId);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 0;
    }

    public int getMusicCurrentPosInMS(long soundId) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeGetMusicCurrentPosInMS(this.mNativeGMESDKAudioEffectJni, soundId);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 0;
    }

    public int setAllMusicVolume(int volume) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeSetAllMusicVolume(this.mNativeGMESDKAudioEffectJni, volume);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int enableMusicPublish(long soundId, boolean enable) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeEnableMusicPublish(this.mNativeGMESDKAudioEffectJni, soundId, enable);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int enableMusicPlayout(long soundId, boolean enable) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeEnableMusicPlayout(this.mNativeGMESDKAudioEffectJni, soundId, enable);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int seekMusicToPosInTime(long soundId, int time) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeSeekMusicToPosInTime(this.mNativeGMESDKAudioEffectJni, soundId, time);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int startRecord(String filePath, int content) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeStartRecord(this.mNativeGMESDKAudioEffectJni, filePath, content);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int stopRecord() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeStopRecord(this.mNativeGMESDKAudioEffectJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int setVoiceType(int type) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeSetVoiceType(this.mNativeGMESDKAudioEffectJni, type);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int setKaraokeType(int type) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioEffectJni != 0L) {
                int n2 = GMESDKAudioEffectJni.nativeSetKaraokeType(this.mNativeGMESDKAudioEffectJni, type);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    private static native int nativeDestroy(long var0);

    private static native int nativeSetMusicPitch(long var0, long var2, float var4);

    private static native int nativeStartPlayMusic(long var0, long var2, String var4, int var5);

    private static native int nativePausePlayMusic(long var0, long var2);

    private static native int nativeResumePlayMusic(long var0, long var2);

    private static native int nativeStopPlayMusic(long var0, long var2);

    private static native boolean nativeIsMusicPlayEnd(long var0, long var2);

    private static native int nativeSetMusicPublishVolume(long var0, long var2, int var4);

    private static native int nativeGetMusicPublishVolume(long var0, long var2);

    private static native int nativeSetMusicPlayoutVolume(long var0, long var2, int var4);

    private static native int nativeGetMusicPlayoutVolume(long var0, long var2);

    private static native int nativeGetMusicDurationInMS(long var0, long var2);

    private static native int nativeGetMusicCurrentPosInMS(long var0, long var2);

    private static native int nativeSetAllMusicVolume(long var0, int var2);

    private static native int nativeEnableMusicPublish(long var0, long var2, boolean var4);

    private static native int nativeEnableMusicPlayout(long var0, long var2, boolean var4);

    private static native int nativeSeekMusicToPosInTime(long var0, long var2, int var4);

    private static native int nativeStartRecord(long var0, String var2, int var3);

    private static native int nativeStopRecord(long var0);

    private static native int nativeSetVoiceType(long var0, int var2);

    private static native int nativeSetKaraokeType(long var0, int var2);
}

