/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.jni;

import com.gme.TMG.ITMGAudioCtrl;
import com.gme.TMG.ITMGType;
import com.gme.liteav.base.annotations.JNINamespace;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@JNINamespace(value="liteav::gme")
public class GMESDKAudioJni {
    private final ReentrantReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock mJniReadLock = this.mReadWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock mJniWriteLock = this.mReadWriteLock.writeLock();
    private long mNativeGMESDKAudioJni;
    private ITMGAudioCtrl.ITMGAudioFrameCallback mAudioFrameCallback = null;

    public GMESDKAudioJni(long nativeGMESDKAudioJni) {
        this.mNativeGMESDKAudioJni = nativeGMESDKAudioJni;
    }

    public int destroy() {
        this.mJniWriteLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeDestroy(this.mNativeGMESDKAudioJni);
                this.mNativeGMESDKAudioJni = 0L;
                return n2;
            }
        }
        finally {
            this.mJniWriteLock.unlock();
        }
        return 1101;
    }

    public int enableAudioSend(boolean enable) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeEnableAudioSend(this.mNativeGMESDKAudioJni, enable);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public boolean isAudioSendEnabled() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                boolean bl = GMESDKAudioJni.nativeIsAudioSendEnabled(this.mNativeGMESDKAudioJni);
                return bl;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return false;
    }

    public int enableAudioRecv(boolean enable) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeEnableAudioRecv(this.mNativeGMESDKAudioJni, enable);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public boolean isAudioRecvEnabled() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                boolean bl = GMESDKAudioJni.nativeIsAudioRecvEnabled(this.mNativeGMESDKAudioJni);
                return bl;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return false;
    }

    public int enableAudioCaptureDevice(boolean enable) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeEnableAudioCaptureDevice(this.mNativeGMESDKAudioJni, enable);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public boolean isAudioCaptureDeviceEnabled() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                boolean bl = GMESDKAudioJni.nativeIsAudioCaptureDeviceEnabled(this.mNativeGMESDKAudioJni);
                return bl;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return false;
    }

    public int enableAudioPlayDevice(boolean enable) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeEnableAudioPlayDevice(this.mNativeGMESDKAudioJni, enable);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public boolean isAudioPlayDeviceEnabled() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                boolean bl = GMESDKAudioJni.nativeIsAudioPlayDeviceEnabled(this.mNativeGMESDKAudioJni);
                return bl;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return false;
    }

    public int setSpeakerVolumeByUserID(String userId, int volume) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeSetSpeakerVolumeByUserID(this.mNativeGMESDKAudioJni, userId, volume);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int getSpeakerVolumeByUserID(String userId) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeGetSpeakerVolumeByUserID(this.mNativeGMESDKAudioJni, userId);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 0;
    }

    public int getMicVolume() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeGetMicVolume(this.mNativeGMESDKAudioJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 0;
    }

    public int setMicVolume(int volume) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeSetMicVolume(this.mNativeGMESDKAudioJni, volume);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int getSpeakerVolume() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeGetSpeakerVolume(this.mNativeGMESDKAudioJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 0;
    }

    public int setSpeakerVolume(int volume) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeSetSpeakerVolume(this.mNativeGMESDKAudioJni, volume);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int enableLoopBack(boolean enable) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeEnableLoopBack(this.mNativeGMESDKAudioJni, enable);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int addAudioBlackList(String userId) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeAddAudioBlackList(this.mNativeGMESDKAudioJni, userId);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int removeAudioBlackList(String userId) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeRemoveAudioBlackList(this.mNativeGMESDKAudioJni, userId);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public boolean isUserIDInAudioBlackList(String userID) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                boolean bl = GMESDKAudioJni.nativeIsUserIDInAudioBlackList(this.mNativeGMESDKAudioJni, userID);
                return bl;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return false;
    }

    public int EnableCustomAudioCapture(boolean enable) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeEnableCustomAudioCapture(this.mNativeGMESDKAudioJni, enable);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int SetAudioRoute(int route) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeSetAudioRoute(this.mNativeGMESDKAudioJni, route);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int SendCustomAudioData(ITMGType.TMGAudioFrame frame) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeSendCustomAudioData(this.mNativeGMESDKAudioJni, new AudioFrame(frame));
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int EnableCustomAudioRendering(boolean enable) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeEnableCustomAudioRendering(this.mNativeGMESDKAudioJni, enable);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int GetCustomAudioRenderingFrame(ITMGType.TMGAudioFrame frame) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeGetCustomAudioRenderingFrame(this.mNativeGMESDKAudioJni, new AudioFrame(frame));
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int TrackingVolume(float interval) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeTrackingVolume(this.mNativeGMESDKAudioJni, interval);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int StopTrackingVolume() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeStopTrackingVolume(this.mNativeGMESDKAudioJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int GetMicLevel() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeGetMicLevel(this.mNativeGMESDKAudioJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 0;
    }

    public int GetSpeakerLevel() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeGetSpeakerLevel(this.mNativeGMESDKAudioJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 0;
    }

    public int GetSendStreamLevel() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeGetSendStreamLevel(this.mNativeGMESDKAudioJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 0;
    }

    public int GetRecvStreamLevel(String userID) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeGetRecvStreamLevel(this.mNativeGMESDKAudioJni, userID);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 0;
    }

    public int InitSpatializer(String modelPath) {
        return 0;
    }

    public int EnableSpatializer(boolean enable) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                int n2 = GMESDKAudioJni.nativeEnableSpatializer(this.mNativeGMESDKAudioJni, enable);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public boolean IsEnableSpatializer() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                boolean bl = GMESDKAudioJni.nativeIsEnableSpatializer(this.mNativeGMESDKAudioJni);
                return bl;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return false;
    }

    public void setAudioFrameCallback(ITMGAudioCtrl.ITMGAudioFrameCallback callback) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKAudioJni != 0L) {
                GMESDKAudioJni.nativeSetAudioFrameCallback(this.mNativeGMESDKAudioJni, this, callback != null);
                this.mAudioFrameCallback = callback;
                return;
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    void onCapturedAudioFrame(byte[] data, long timestamp, int sampleRate, int channels) {
        if (this.mAudioFrameCallback == null) {
            return;
        }
        ITMGType.TMGAudioFrame tMGAudioFrame = new ITMGType.TMGAudioFrame();
        new ITMGType.TMGAudioFrame().data = data;
        tMGAudioFrame.timestamp = timestamp;
        tMGAudioFrame.sample_rate = sampleRate;
        tMGAudioFrame.channel = channels;
        this.mAudioFrameCallback.OnCapturedAudioFrame(tMGAudioFrame);
    }

    void onLocalProcessedAudioFrame(byte[] data, long timestamp, int sampleRate, int channels) {
        if (this.mAudioFrameCallback == null) {
            return;
        }
        ITMGType.TMGAudioFrame tMGAudioFrame = new ITMGType.TMGAudioFrame();
        new ITMGType.TMGAudioFrame().data = data;
        tMGAudioFrame.timestamp = timestamp;
        tMGAudioFrame.sample_rate = sampleRate;
        tMGAudioFrame.channel = channels;
        this.mAudioFrameCallback.OnLocalProcessedAudioFrame(tMGAudioFrame);
    }

    void onPlayAudioFrame(byte[] data, long timestamp, int sampleRate, int channels, String userID) {
        if (this.mAudioFrameCallback == null) {
            return;
        }
        ITMGType.TMGAudioFrame tMGAudioFrame = new ITMGType.TMGAudioFrame();
        new ITMGType.TMGAudioFrame().data = data;
        tMGAudioFrame.timestamp = timestamp;
        tMGAudioFrame.sample_rate = sampleRate;
        tMGAudioFrame.channel = channels;
        this.mAudioFrameCallback.OnPlayAudioFrame(tMGAudioFrame, userID);
    }

    void onMixedPlayAudioFrame(byte[] data, long timestamp, int sampleRate, int channels) {
        if (this.mAudioFrameCallback == null) {
            return;
        }
        ITMGType.TMGAudioFrame tMGAudioFrame = new ITMGType.TMGAudioFrame();
        new ITMGType.TMGAudioFrame().data = data;
        tMGAudioFrame.timestamp = timestamp;
        tMGAudioFrame.sample_rate = sampleRate;
        tMGAudioFrame.channel = channels;
        this.mAudioFrameCallback.OnMixedPlayAudioFrame(tMGAudioFrame);
    }

    void onMixedAllAudioFrame(byte[] data, long timestamp, int sampleRate, int channels) {
        if (this.mAudioFrameCallback == null) {
            return;
        }
        ITMGType.TMGAudioFrame tMGAudioFrame = new ITMGType.TMGAudioFrame();
        new ITMGType.TMGAudioFrame().data = data;
        tMGAudioFrame.timestamp = timestamp;
        tMGAudioFrame.sample_rate = sampleRate;
        tMGAudioFrame.channel = channels;
        this.mAudioFrameCallback.OnMixedAllAudioFrame(tMGAudioFrame);
    }

    private static native int nativeDestroy(long var0);

    private static native int nativeEnableAudioCaptureDevice(long var0, boolean var2);

    private static native boolean nativeIsAudioCaptureDeviceEnabled(long var0);

    private static native int nativeEnableAudioPlayDevice(long var0, boolean var2);

    private static native boolean nativeIsAudioPlayDeviceEnabled(long var0);

    private static native int nativeSetSpeakerVolumeByUserID(long var0, String var2, int var3);

    private static native int nativeGetSpeakerVolumeByUserID(long var0, String var2);

    private static native int nativeGetMicVolume(long var0);

    private static native int nativeSetMicVolume(long var0, int var2);

    private static native int nativeGetSpeakerVolume(long var0);

    private static native int nativeSetSpeakerVolume(long var0, int var2);

    private static native int nativeEnableLoopBack(long var0, boolean var2);

    private static native int nativeAddAudioBlackList(long var0, String var2);

    private static native int nativeRemoveAudioBlackList(long var0, String var2);

    private static native boolean nativeIsUserIDInAudioBlackList(long var0, String var2);

    private static native int nativeEnableAudioSend(long var0, boolean var2);

    private static native boolean nativeIsAudioSendEnabled(long var0);

    private static native int nativeEnableAudioRecv(long var0, boolean var2);

    private static native boolean nativeIsAudioRecvEnabled(long var0);

    private static native int nativeEnableCustomAudioCapture(long var0, boolean var2);

    private static native int nativeSetAudioRoute(long var0, int var2);

    private static native int nativeSendCustomAudioData(long var0, AudioFrame var2);

    private static native int nativeEnableCustomAudioRendering(long var0, boolean var2);

    private static native int nativeGetCustomAudioRenderingFrame(long var0, AudioFrame var2);

    private static native int nativeTrackingVolume(long var0, float var2);

    private static native int nativeStopTrackingVolume(long var0);

    private static native int nativeGetMicLevel(long var0);

    private static native int nativeGetSpeakerLevel(long var0);

    private static native int nativeGetSendStreamLevel(long var0);

    private static native int nativeGetRecvStreamLevel(long var0, String var2);

    private static native int nativeEnableSpatializer(long var0, boolean var2);

    private static native boolean nativeIsEnableSpatializer(long var0);

    private static native int nativeSetAudioFrameCallback(long var0, GMESDKAudioJni var2, boolean var3);

    static class AudioFrame {
        private ITMGType.TMGAudioFrame a;

        public AudioFrame(ITMGType.TMGAudioFrame frame) {
            this.a = frame;
        }

        public byte[] getData() {
            return this.a.data;
        }

        public int getSampleRate() {
            return this.a.sample_rate;
        }

        public int getChannel() {
            return this.a.channel;
        }

        public long getTimestamp() {
            return this.a.timestamp;
        }
    }
}

