/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.jni;

import com.gme.TMG.ITMGContext;
import com.gme.TMG.ITMGType;
import com.gme.av.jni.GMESDKAudioEffectJni;
import com.gme.av.jni.GMESDKAudioJni;
import com.gme.av.jni.GMESDKPTTJni;
import com.gme.av.jni.GMESDKRoomJni;
import com.gme.av.utils.EventHelper;
import com.gme.av.utils.GMELibLoader;
import com.gme.liteav.base.annotations.JNINamespace;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@JNINamespace(value="liteav::gme")
public class GMESDKJni {
    public static final String TAG = GMESDKJni.class.getSimpleName();
    private final ReentrantReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock mJniReadLock = this.mReadWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock mJniWriteLock = this.mReadWriteLock.writeLock();
    private long mNativeGMESDKJni = GMESDKJni.nativeCreateContext(this);
    private ITMGContext.ITMGDelegate mDelegate;
    private final GMESDKAudioJni mAudioJni = new GMESDKAudioJni(GMESDKJni.nativeCreateAudioCtrl(this.mNativeGMESDKJni));
    private final GMESDKAudioEffectJni mAudioEffectJni = new GMESDKAudioEffectJni(GMESDKJni.nativeCreateAudioEffectCtrl(this.mNativeGMESDKJni));
    private final GMESDKRoomJni mRoomJni = new GMESDKRoomJni(GMESDKJni.nativeCreateRoom(this.mNativeGMESDKJni));
    private final GMESDKPTTJni mPttJni = new GMESDKPTTJni(GMESDKJni.nativeCreatePTT(this.mNativeGMESDKJni));

    public GMESDKAudioJni getAudioJni() {
        return this.mAudioJni;
    }

    public GMESDKAudioEffectJni getAudioEffectJni() {
        return this.mAudioEffectJni;
    }

    public GMESDKRoomJni getRoomJni() {
        return this.mRoomJni;
    }

    public GMESDKPTTJni getPTTJni() {
        return this.mPttJni;
    }

    public int destroy() {
        this.destroyOther();
        this.mAudioJni.destroy();
        this.mJniWriteLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                GMESDKJni.nativeDestroyContext(this.mNativeGMESDKJni);
                this.mNativeGMESDKJni = 0L;
            }
        }
        finally {
            this.mJniWriteLock.unlock();
        }
        return 1101;
    }

    private void destroyOther() {
        this.mAudioJni.destroy();
        this.mAudioEffectJni.destroy();
        this.mRoomJni.destroy();
    }

    public int poll() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                int n2 = GMESDKJni.nativePoll(this.mNativeGMESDKJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int pause() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                int n2 = GMESDKJni.nativePause(this.mNativeGMESDKJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int resume() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                int n2 = GMESDKJni.nativeResume(this.mNativeGMESDKJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int setLogLevel(int levelWrite, int levelPrint) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                int n2 = GMESDKJni.nativeSetLogLevel(this.mNativeGMESDKJni, levelWrite, levelPrint);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int setLogPath(String logPath) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                int n2 = GMESDKJni.nativeSetLogPath(this.mNativeGMESDKJni, logPath);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public String getLogPath() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                String string = GMESDKJni.nativeGetLogPath(this.mNativeGMESDKJni);
                return string;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return null;
    }

    public int showDebugView(boolean enable) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                int n2 = GMESDKJni.nativeShowDebugView(this.mNativeGMESDKJni, enable);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public void setRegion(String region) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                GMESDKJni.nativeSetRegion(this.mNativeGMESDKJni, region);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setDelegate(ITMGContext.ITMGDelegate delegate) {
        this.mDelegate = delegate;
    }

    public int init(String appId, String userId) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                int n2 = GMESDKJni.nativeInit(this.mNativeGMESDKJni, appId, userId);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int unInit() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                int n2 = GMESDKJni.nativeUnInit(this.mNativeGMESDKJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public String getSDKVersion() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                String string = GMESDKJni.nativeGetSDKVersion(this.mNativeGMESDKJni);
                return string;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return null;
    }

    public int setScene(int scene) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                int n2 = GMESDKJni.nativeSetScene(this.mNativeGMESDKJni, scene);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public void setAppVersion(String appVersion) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                GMESDKJni.nativeSetAppVersion(this.mNativeGMESDKJni, appVersion);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public int setAdvanceParams(String key, String value) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                int n2 = GMESDKJni.nativeSetAdvanceParams(this.mNativeGMESDKJni, key, value);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public String getAdvanceParam(String key) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                String string = GMESDKJni.nativeGetAdvanceParam(this.mNativeGMESDKJni, key);
                return string;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return null;
    }

    public int enterRoom(String roomId, int roomType, byte[] userSig) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                int n2 = GMESDKJni.nativeEnterRoom(this.mNativeGMESDKJni, roomId, roomType, userSig);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int exitRoom() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                int n2 = GMESDKJni.nativeExitRoom(this.mNativeGMESDKJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public boolean isRoomEntered() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                boolean bl = GMESDKJni.nativeIsRoomEntered(this.mNativeGMESDKJni);
                return bl;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return false;
    }

    public int setRecvMixStreamCount(int count) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                int n2 = GMESDKJni.nativeSetRecvMixStreamCount(this.mNativeGMESDKJni, count);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int setAudioRole(int roleType) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                int n2 = GMESDKJni.nativeSetAudioRole(this.mNativeGMESDKJni, roleType);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int setRangeAudioMode(int rangeAudioMode) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                int n2 = GMESDKJni.nativeSetRangeAudioMode(this.mNativeGMESDKJni, rangeAudioMode);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int setRangeAudioTeamID(int teamID) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                int n2 = GMESDKJni.nativeSetTeamID(this.mNativeGMESDKJni, teamID);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public static byte[] genAuthBuffer(int appId, String roomId, String userId, String appKey) {
        return GMESDKJni.nativeGenAuthBuffer(appId, roomId, userId, appKey);
    }

    public int checkMicPermission() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKJni != 0L) {
                int n2 = GMESDKJni.nativeCheckMicPermission(this.mNativeGMESDKJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return ITMGType.ITMG_MIC_PERMISSION.ITMG_PERMISSION_NotDetermined.ordinal();
    }

    public void onEvent(int eventId, String data) {
        if (this.mDelegate != null) {
            this.mDelegate.OnEvent(EventHelper.idToEvent(eventId), EventHelper.parserEvent(data));
        }
    }

    private static native long nativeCreateContext(GMESDKJni var0);

    private static native int nativeDestroyContext(long var0);

    private static native long nativeCreateAudioCtrl(long var0);

    private static native long nativeCreateAudioEffectCtrl(long var0);

    private static native long nativeCreateRoom(long var0);

    private static native long nativeCreatePTT(long var0);

    private static native int nativePoll(long var0);

    private static native int nativePause(long var0);

    private static native int nativeResume(long var0);

    private static native int nativeSetLogLevel(long var0, int var2, int var3);

    private static native int nativeSetLogPath(long var0, String var2);

    private static native String nativeGetLogPath(long var0);

    private static native int nativeShowDebugView(long var0, boolean var2);

    private static native void nativeSetRegion(long var0, String var2);

    private static native int nativeInit(long var0, String var2, String var3);

    private static native int nativeUnInit(long var0);

    private static native String nativeGetSDKVersion(long var0);

    private static native void nativeSetAppVersion(long var0, String var2);

    private static native int nativeSetScene(long var0, int var2);

    private static native int nativeSetAdvanceParams(long var0, String var2, String var3);

    private static native String nativeGetAdvanceParam(long var0, String var2);

    private static native int nativeEnterRoom(long var0, String var2, int var3, byte[] var4);

    private static native int nativeExitRoom(long var0);

    private static native boolean nativeIsRoomEntered(long var0);

    private static native int nativeSetRecvMixStreamCount(long var0, int var2);

    private static native int nativeSetAudioRole(long var0, int var2);

    private static native int nativeSetRangeAudioMode(long var0, int var2);

    private static native int nativeSetTeamID(long var0, int var2);

    private static native byte[] nativeGenAuthBuffer(int var0, String var1, String var2, String var3);

    private static native int nativeCheckMicPermission(long var0);

    static {
        GMELibLoader.loadSdkLibrary();
    }
}

