/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.jni;

import com.gme.liteav.base.annotations.JNINamespace;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@JNINamespace(value="liteav::gme")
public class GMESDKPTTJni {
    private final ReentrantReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock mJniReadLock = this.mReadWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock mJniWriteLock = this.mReadWriteLock.writeLock();
    private long mNativeGMESDKPTTJni;

    public GMESDKPTTJni(long nativeGMESDKPTTJni) {
        this.mNativeGMESDKPTTJni = nativeGMESDKPTTJni;
    }

    public int destroy() {
        this.mJniWriteLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeDestroy(this.mNativeGMESDKPTTJni);
                this.mNativeGMESDKPTTJni = 0L;
                return n2;
            }
        }
        finally {
            this.mJniWriteLock.unlock();
        }
        return 1101;
    }

    public int applyPTTAuthbuffer(byte[] userSig) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeApplyPTTAuthbuffer(this.mNativeGMESDKPTTJni, userSig);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int setMaxMessageLength(int msTime) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeSetMaxMessageLength(this.mNativeGMESDKPTTJni, msTime);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int startRecording(String filePath) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeStartRecording(this.mNativeGMESDKPTTJni, filePath);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int stopRecording() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeStopRecording(this.mNativeGMESDKPTTJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int cancelRecording() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeCancelRecording(this.mNativeGMESDKPTTJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int uploadRecordedFile(String filePath) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeUploadRecordedFile(this.mNativeGMESDKPTTJni, filePath);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int downloadRecordedFile(String fileId, String filePath) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeDownloadRecordedFile(this.mNativeGMESDKPTTJni, fileId, filePath);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int playRecordedFile(String filePath, int voiceType) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativePlayRecordedFile(this.mNativeGMESDKPTTJni, filePath, voiceType);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int stopPlayFile() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeStopPlayFile(this.mNativeGMESDKPTTJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int speechToText(String fileID) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeSpeechToText(this.mNativeGMESDKPTTJni, fileID, "", "");
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int speechToText(String fileID, String speechLanguage) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                String string = speechLanguage;
                int n2 = GMESDKPTTJni.nativeSpeechToText(this.mNativeGMESDKPTTJni, fileID, string, string);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int speechToText(String fileID, String speechLanguage, String translateLanguage) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeSpeechToText(this.mNativeGMESDKPTTJni, fileID, speechLanguage, translateLanguage);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int translateText(String text, String sourceLanguage, String translateLanguage) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeTranslateText(this.mNativeGMESDKPTTJni, text, sourceLanguage, translateLanguage);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int getFileSize(String filePath) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeGetFileSize(this.mNativeGMESDKPTTJni, filePath);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int getVoiceFileDuration(String filePath) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeGetVoiceFileDuration(this.mNativeGMESDKPTTJni, filePath);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int startRecordingWithStreamingRecognition(String filePath) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeStartRecordingWithStreamingRecognition(this.mNativeGMESDKPTTJni, filePath, "cmn-Hans-CN", "cmn-Hans-CN");
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int startRecordingWithStreamingRecognition(String filePath, String speechLanguage) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                String string = speechLanguage;
                int n2 = GMESDKPTTJni.nativeStartRecordingWithStreamingRecognition(this.mNativeGMESDKPTTJni, filePath, string, string);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int startRecordingWithStreamingRecognition(String filePath, String speechLanguage, String translateLanguage) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeStartRecordingWithStreamingRecognition(this.mNativeGMESDKPTTJni, filePath, speechLanguage, translateLanguage);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int setPTTSourceLanguage(String sourceLanguage) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeSetPTTSourceLanguage(this.mNativeGMESDKPTTJni, sourceLanguage);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int textToSpeech(int serialNumber, String text, String voiceName, String languageCode, float speakingRate) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKPTTJni != 0L) {
                int n2 = GMESDKPTTJni.nativeTextToSpeech(this.mNativeGMESDKPTTJni, serialNumber, text, voiceName, languageCode, speakingRate);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    private static native int nativeDestroy(long var0);

    private static native int nativeApplyPTTAuthbuffer(long var0, byte[] var2);

    private static native int nativeSetMaxMessageLength(long var0, int var2);

    private static native int nativeStartRecording(long var0, String var2);

    private static native int nativeStopRecording(long var0);

    private static native int nativeCancelRecording(long var0);

    private static native int nativeUploadRecordedFile(long var0, String var2);

    private static native int nativeDownloadRecordedFile(long var0, String var2, String var3);

    private static native int nativePlayRecordedFile(long var0, String var2, int var3);

    private static native int nativeStopPlayFile(long var0);

    private static native int nativeSpeechToText(long var0, String var2, String var3, String var4);

    private static native int nativeTranslateText(long var0, String var2, String var3, String var4);

    private static native int nativeGetFileSize(long var0, String var2);

    private static native int nativeGetVoiceFileDuration(long var0, String var2);

    private static native int nativeStartRecordingWithStreamingRecognition(long var0, String var2, String var3, String var4);

    private static native int nativeSetPTTSourceLanguage(long var0, String var2);

    private static native int nativeTextToSpeech(long var0, int var2, String var3, String var4, String var5, float var6);
}

