/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.jni;

import com.gme.liteav.base.annotations.JNINamespace;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@JNINamespace(value="liteav::gme")
public class GMESDKRoomJni {
    private final ReentrantReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock mJniReadLock = this.mReadWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock mJniWriteLock = this.mReadWriteLock.writeLock();
    private long mNativeGMESDKRoomJni;

    public GMESDKRoomJni(long nativeGMESDKRoomJni) {
        this.mNativeGMESDKRoomJni = nativeGMESDKRoomJni;
    }

    public int destroy() {
        this.mJniWriteLock.lock();
        try {
            if (this.mNativeGMESDKRoomJni != 0L) {
                int n2 = GMESDKRoomJni.nativeDestroy(this.mNativeGMESDKRoomJni);
                this.mNativeGMESDKRoomJni = 0L;
                return n2;
            }
        }
        finally {
            this.mJniWriteLock.unlock();
        }
        return 1101;
    }

    public String getRoomID() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKRoomJni != 0L) {
                String string = GMESDKRoomJni.nativeGetRoomID(this.mNativeGMESDKRoomJni);
                return string;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return null;
    }

    public int startRoomSharing(String targetRoomId, String targetUserID, byte[] userSig) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKRoomJni != 0L) {
                int n2 = GMESDKRoomJni.nativeStartRoomSharing(this.mNativeGMESDKRoomJni, targetRoomId, targetUserID, userSig);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int stopRoomSharing() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKRoomJni != 0L) {
                int n2 = GMESDKRoomJni.nativeStopRoomSharing(this.mNativeGMESDKRoomJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int changeRoomType(int roomType) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKRoomJni != 0L) {
                int n2 = GMESDKRoomJni.nativeChangeRoomType(this.mNativeGMESDKRoomJni, roomType);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int getRoomType() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKRoomJni != 0L) {
                int n2 = GMESDKRoomJni.nativeGetRoomType(this.mNativeGMESDKRoomJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 0;
    }

    public int switchRoom(String roomId, byte[] userSig) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKRoomJni != 0L) {
                int n2 = GMESDKRoomJni.nativeSwitchRoom(this.mNativeGMESDKRoomJni, roomId, userSig);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int sendCustomData(byte[] data, int repeatCount) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKRoomJni != 0L) {
                int n2 = GMESDKRoomJni.nativeSendCustomData(this.mNativeGMESDKRoomJni, data, repeatCount);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int stopSendCustomData() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKRoomJni != 0L) {
                int n2 = GMESDKRoomJni.nativeStopSendCustomData(this.mNativeGMESDKRoomJni);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int updateAudioRecvRange(float range) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKRoomJni != 0L) {
                int n2 = GMESDKRoomJni.nativeUpdateAudioRecvRange(this.mNativeGMESDKRoomJni, range);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int updateSelfPosition(float[] position, float[] axisfForward, float[] axisRight, float[] axisUp) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKRoomJni != 0L) {
                int n2 = GMESDKRoomJni.nativeUpdateSelfPosition(this.mNativeGMESDKRoomJni, position, axisfForward, axisRight, axisUp);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int updateSpatializerRecvRange(float range) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKRoomJni != 0L) {
                int n2 = GMESDKRoomJni.nativeUpdateSpatializerRecvRange(this.mNativeGMESDKRoomJni, range);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int updateOtherPosition(String userID, float[] position) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKRoomJni != 0L) {
                int n2 = GMESDKRoomJni.nativeUpdateOtherPosition(this.mNativeGMESDKRoomJni, userID, position);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    public int sendSEIMsg(String message, int repeatCount) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeGMESDKRoomJni != 0L) {
                int n2 = GMESDKRoomJni.nativeSendSEIMsg(this.mNativeGMESDKRoomJni, message, repeatCount);
                return n2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return 1101;
    }

    private static native int nativeDestroy(long var0);

    private static native String nativeGetRoomID(long var0);

    private static native int nativeStartRoomSharing(long var0, String var2, String var3, byte[] var4);

    private static native int nativeStopRoomSharing(long var0);

    private static native int nativeChangeRoomType(long var0, int var2);

    private static native int nativeGetRoomType(long var0);

    private static native int nativeSwitchRoom(long var0, String var2, byte[] var3);

    private static native int nativeSendCustomData(long var0, byte[] var2, int var3);

    private static native int nativeStopSendCustomData(long var0);

    private static native int nativeUpdateAudioRecvRange(long var0, float var2);

    private static native int nativeUpdateSelfPosition(long var0, float[] var2, float[] var3, float[] var4, float[] var5);

    private static native int nativeUpdateSpatializerRecvRange(long var0, float var2);

    private static native int nativeUpdateOtherPosition(long var0, String var2, float[] var3);

    private static native int nativeSendSEIMsg(long var0, String var2, int var3);
}

