/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.utils;

import android.text.TextUtils;
import android.util.Log;

public final class GMELibLoader {
    public static final String TAG = GMELibLoader.class.getSimpleName();
    private static final Object mLoadLock = new Object();
    private static boolean mHasLoaded = false;
    private static String mLibraryPath = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadSdkLibrary() {
        Object object = mLoadLock;
        synchronized (object) {
            if (!mHasLoaded) {
                boolean bl = GMELibLoader.loadLibrary("txsoundtouch");
                Log.w((String)TAG, (String)"load library txsoundtouch ".concat(String.valueOf(bl)));
                bl = GMELibLoader.loadLibrary("txffmpeg");
                Log.w((String)TAG, (String)"load library txffmpeg ".concat(String.valueOf(bl)));
                bl = GMELibLoader.loadLibrary("gmesdk");
                Log.w((String)TAG, (String)"load library gmesdk ".concat(String.valueOf(bl)));
                mHasLoaded = bl;
            }
        }
        return 0;
    }

    private static boolean loadLibrary(String name) {
        try {
            boolean bl = false;
            if (!TextUtils.isEmpty((CharSequence)mLibraryPath)) {
                bl = GMELibLoader.loadLibrary(mLibraryPath, name);
            }
            if (!bl) {
                Log.w((String)TAG, (String)("load library " + name + " from system path "));
                System.loadLibrary(name);
            }
            return true;
        }
        catch (Error | Exception throwable) {
            Log.w((String)TAG, (String)("load library : " + throwable.toString()));
            return false;
        }
    }

    public static boolean loadLibrary(String path, String name) {
        boolean bl = false;
        try {
            if (!TextUtils.isEmpty((CharSequence)path)) {
                Log.w((String)TAG, (String)("load library " + name + " from path " + path));
                System.load(path + "/lib" + name + ".so");
                bl = true;
            }
        }
        catch (Error | Exception throwable) {
            Log.w((String)TAG, (String)("load library : " + throwable.toString()));
        }
        return bl;
    }

    public static String getLibraryPath() {
        return mLibraryPath;
    }

    public static void setLibraryPath(String path) {
        Log.w((String)TAG, (String)"setLibraryPath ".concat(String.valueOf(path)));
        mLibraryPath = path;
    }

    public static boolean isLoadLibrary() {
        return mHasLoaded;
    }
}

