/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.utils;

import android.content.Intent;
import android.os.Parcelable;
import android.util.Log;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonParser {
    public static final String TAG = JsonParser.class.getSimpleName();

    public static Intent ParseJsonString(String jsonString) {
        if (jsonString != null && jsonString.startsWith("\ufeff")) {
            jsonString = jsonString.substring(1);
        }
        Intent intent = new Intent();
        try {
            JSONObject jSONObject = new JSONObject(jsonString);
            JsonParser.ParseJsonObject(intent, jSONObject);
            return intent;
        }
        catch (JSONException jSONException) {
            return intent;
        }
    }

    public static void ParseJsonObject(Intent it, JSONObject jsonObject) {
        if (it == null || jsonObject == null) {
            return;
        }
        try {
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object object = jsonObject.get(string);
                if (object instanceof Integer) {
                    it.putExtra(string, jsonObject.getInt(string));
                    continue;
                }
                if (object instanceof String) {
                    it.putExtra(string, jsonObject.getString(string));
                    continue;
                }
                if (object instanceof Long) {
                    it.putExtra(string, jsonObject.getLong(string));
                    continue;
                }
                if (object instanceof Boolean) {
                    it.putExtra(string, jsonObject.getBoolean(string));
                    continue;
                }
                if (object instanceof Double) {
                    it.putExtra(string, jsonObject.getDouble(string));
                    continue;
                }
                if (object instanceof JSONObject) {
                    Intent intent = new Intent();
                    it.putExtra(string, (Parcelable)intent);
                    JsonParser.ParseJsonObject(intent, jsonObject.getJSONObject(string));
                    continue;
                }
                if (!(object instanceof JSONArray)) continue;
                JsonParser.ParseJsonArray(it, string, jsonObject.getJSONArray(string));
            }
            return;
        }
        catch (JSONException jSONException) {
            Log.w((String)TAG, (String)"ParseJsonObject error  ", (Throwable)jSONException);
            return;
        }
    }

    public static void ParseJsonArray(Intent it, String key, JSONArray jsonArray) {
        int n2 = jsonArray.length();
        if (n2 <= 0) {
            return;
        }
        try {
            Object object = jsonArray.get(0);
            if (object instanceof Integer) {
                int[] nArray = new int[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    nArray[i2] = jsonArray.getInt(i2);
                }
                it.putExtra(key, nArray);
                return;
            }
            if (object instanceof String) {
                String[] stringArray = new String[n2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    stringArray[i3] = jsonArray.getString(i3);
                }
                it.putExtra(key, stringArray);
                return;
            }
            if (object instanceof Long) {
                long[] lArray = new long[n2];
                for (int i4 = 0; i4 < n2; ++i4) {
                    lArray[i4] = jsonArray.getLong(i4);
                }
                it.putExtra(key, lArray);
                return;
            }
            if (object instanceof Boolean) {
                boolean[] blArray = new boolean[n2];
                for (int i5 = 0; i5 < n2; ++i5) {
                    blArray[i5] = jsonArray.getBoolean(i5);
                }
                it.putExtra(key, blArray);
                return;
            }
            if (object instanceof Double) {
                double[] dArray = new double[n2];
                for (int i6 = 0; i6 < n2; ++i6) {
                    dArray[i6] = jsonArray.getDouble(i6);
                }
                it.putExtra(key, dArray);
                return;
            }
            if (object instanceof JSONObject) {
                Intent[] intentArray = new Intent[jsonArray.length()];
                for (int i7 = 0; i7 < n2; ++i7) {
                    intentArray[i7] = new Intent();
                    JsonParser.ParseJsonObject(intentArray[i7], jsonArray.getJSONObject(i7));
                }
                it.putExtra(key, (Parcelable[])intentArray);
            }
            return;
        }
        catch (JSONException jSONException) {
            Log.w((String)TAG, (String)"ParseJsonArray error  ", (Throwable)jSONException);
            return;
        }
    }
}

