/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.utils;

import android.util.Log;
import com.gme.av.utils.GMELibLoader;

public class QLog {
    public static final int ERROR = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    public static final int VERBOSE = 4;
    private static volatile boolean useAvsdkLogger = true;

    public static void d(String tag, String msg) {
        if (useAvsdkLogger) {
            QLog.writeLog(3, tag, msg);
            return;
        }
        Log.d((String)tag, (String)msg);
    }

    public static void d(String tag, String msg, Exception e2) {
        if (useAvsdkLogger) {
            QLog.writeLog(3, tag, msg, e2);
            return;
        }
        Log.d((String)tag, (String)msg, (Throwable)e2);
    }

    public static void w(String tag, String msg) {
        if (useAvsdkLogger) {
            QLog.writeLog(1, tag, msg);
            return;
        }
        Log.w((String)tag, (String)msg);
    }

    public static void w(String tag, String msg, Exception e2) {
        if (useAvsdkLogger) {
            QLog.writeLog(1, tag, msg, e2);
            return;
        }
        Log.w((String)tag, (String)msg, (Throwable)e2);
    }

    public static void e(String tag, String msg) {
        if (useAvsdkLogger) {
            QLog.writeLog(1, tag, msg);
            return;
        }
        Log.e((String)tag, (String)msg);
    }

    public static void e(String tag, String msg, Exception e2) {
        if (useAvsdkLogger) {
            QLog.writeLog(1, tag, msg, e2);
            return;
        }
        Log.e((String)tag, (String)msg, (Throwable)e2);
    }

    public static void i(String tag, String msg) {
        if (useAvsdkLogger) {
            QLog.writeLog(2, tag, msg);
            return;
        }
        Log.i((String)tag, (String)msg);
    }

    public static void i(String tag, String msg, Exception e2) {
        if (useAvsdkLogger) {
            QLog.writeLog(2, tag, msg, e2);
            return;
        }
        Log.i((String)tag, (String)msg, (Throwable)e2);
    }

    public static void v(String tag, String msg) {
        if (useAvsdkLogger) {
            QLog.writeLog(4, tag, msg);
            return;
        }
        Log.i((String)tag, (String)msg);
    }

    public static void v(String tag, String msg, Exception e2) {
        if (useAvsdkLogger) {
            QLog.writeLog(4, tag, msg, e2);
            return;
        }
        Log.i((String)tag, (String)msg, (Throwable)e2);
    }

    private static void writeLog(int level, String tag, String msg) {
        QLog.writeLog(level, tag, msg, null);
    }

    private static void writeLog(int level, String tag, String msg, Exception e2) {
        String string = String.format("[%s]%s", tag, msg);
        if (e2 != null) {
            string = string + ", " + Log.getStackTraceString((Throwable)e2);
        }
        if (GMELibLoader.isLoadLibrary()) {
            QLog.nativeWriteLog(level, string);
            return;
        }
        Log.i((String)tag, (String)string);
    }

    private static void nativeWriteLog(int level, String msg) {
        Log.i((String)"Native", (String)msg);
    }

    private static String nativeGetLogDir() {
        return "";
    }

    public static String getLogDir() {
        return QLog.nativeGetLogDir();
    }
}

