/*
 * Decompiled with CFR 0.152.
 */
package com.gme.liteav.audio.musicdecoder;

import android.media.MediaFormat;
import com.gme.liteav.audio.musicdecoder.MediaCodecBridge;
import com.gme.liteav.base.Log;
import com.gme.liteav.base.annotations.JNINamespace;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::audio")
public class MusicResourceDecoderAndroid {
    private static final String TAG = "MusicResourceDecoderAndroid";
    private final MediaCodecBridge mDecoder = new MediaCodecBridge();
    private String mPath;
    private int mTrackIndex = 0;

    public boolean start(String path) {
        this.mPath = path;
        return this.mDecoder.initAndStart(path);
    }

    public boolean seekTo(long timeMs) {
        if (this.mDecoder.isDecodeEnd()) {
            this.mDecoder.stop();
            this.mDecoder.initAndStart(this.mPath);
            this.mDecoder.setMusicTrack(this.mTrackIndex);
        }
        return this.mDecoder.seekTo(timeMs * 1000L);
    }

    public ByteBuffer decode() {
        return this.mDecoder.processFrame();
    }

    public int getSampleRate() {
        MediaFormat mediaFormat = this.mDecoder.getOutputFormat();
        if (mediaFormat == null) {
            return -1;
        }
        int n2 = -1;
        try {
            n2 = mediaFormat.getInteger("sample-rate");
        }
        catch (Throwable throwable) {
            Log.e(TAG, "getSampleRate failed. " + throwable.getMessage(), new Object[0]);
        }
        return n2;
    }

    public int getChannelCount() {
        MediaFormat mediaFormat = this.mDecoder.getOutputFormat();
        if (mediaFormat == null) {
            return -1;
        }
        int n2 = -1;
        try {
            n2 = mediaFormat.getInteger("channel-count");
        }
        catch (Throwable throwable) {
            Log.e(TAG, "getChannelCount failed. " + throwable.getMessage(), new Object[0]);
        }
        return n2;
    }

    public long getDuration() {
        return (this.mDecoder.getLongestDuration() + 500L) / 1000L;
    }

    public int getBitrate() {
        MediaFormat mediaFormat = this.mDecoder.getOutputFormat();
        if (mediaFormat == null) {
            return -1;
        }
        int n2 = -1;
        try {
            n2 = mediaFormat.getInteger("bitrate");
        }
        catch (Throwable throwable) {
            Log.e(TAG, "getBitrate failed. " + throwable.getMessage(), new Object[0]);
        }
        return n2;
    }

    public int getTrackCount() {
        return this.mDecoder.getTrackCount();
    }

    public void setMusicTrack(int index) {
        this.mTrackIndex = index;
        this.mDecoder.setMusicTrack(index);
    }

    public int getTotalRawDataSize() {
        return this.mDecoder.getTotalRawDataSize();
    }

    public boolean isDecodeEnd() {
        return this.mDecoder.isDecodeEnd();
    }

    public void stop() {
        this.mDecoder.stop();
    }
}

