/*
 * Decompiled with CFR 0.152.
 */
package com.gme.liteav.audio2;

import android.media.AudioRecord;
import android.media.AudioTimestamp;
import android.os.Process;
import com.gme.liteav.base.Log;
import com.gme.liteav.base.annotations.JNINamespace;
import com.gme.liteav.base.system.LiteavSystemInfo;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::audio")
class LiteavAudioRecord3 {
    private static final String TAG = "LiteavAudioRecord3";
    private static final int DEFAULT_LATENCY_MS = 30;
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final long NANOS_PER_MS = 1000000L;
    private static final int HARDWARE_LATENCY_MS = 20;
    private static final long LATENCY_THRESHOLD_MS = 1000L;
    private AudioRecord mAudioRecord;
    private int mSampleRate = 0;
    private int mBufferSize = 0;
    private int mReadFrameIndex = 0;
    private int mBytesPerFrame = 0;
    private int mSystemOSVersion = 0;

    private AudioRecord createStartedAudioRecord(int audioSource, int sampleRate, int channelConfig, int bufferSize) {
        AudioRecord audioRecord = null;
        try {
            audioRecord = new AudioRecord(audioSource, sampleRate, channelConfig, 2, bufferSize);
            if (audioRecord.getState() != 1) {
                throw new RuntimeException("AudioRecord is not initialized.");
            }
            this.mReadFrameIndex = 0;
            audioRecord.startRecording();
            Log.i(TAG, "create AudioRecord success. sampleRate: %d, channelConfig: %d, bufferSize: %d, audio source: %s", sampleRate, channelConfig, bufferSize, LiteavAudioRecord3.audioSourceToString(audioSource));
        }
        catch (Throwable throwable) {
            Log.w(TAG, "create AudioRecord failed. source: %s, sampleRate: %d, channelConfig: %d, bufferSize: %d", LiteavAudioRecord3.audioSourceToString(audioSource), sampleRate, channelConfig, bufferSize);
            LiteavAudioRecord3.destroyAudioRecord(audioRecord);
            audioRecord = null;
        }
        return audioRecord;
    }

    private static void destroyAudioRecord(AudioRecord audioRecord) {
        if (audioRecord == null) {
            return;
        }
        try {
            if (audioRecord.getRecordingState() == 3) {
                audioRecord.stop();
            }
            audioRecord.release();
            return;
        }
        catch (Throwable throwable) {
            Log.e(TAG, "stop AudioRecord failed.", throwable);
            return;
        }
    }

    private static String audioSourceToString(int source) {
        switch (source) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "MIC";
            }
            case 2: {
                return "VOICE_UPLINK";
            }
            case 3: {
                return "VOICE_DOWNLINK";
            }
            case 4: {
                return "VOICE_CALL";
            }
            case 5: {
                return "CAMCORDER";
            }
            case 6: {
                return "VOICE_RECOGNITION";
            }
            case 7: {
                return "VOICE_COMMUNICATION";
            }
            case 9: {
                return "UNPROCESSED";
            }
            case 10: {
                return "VOICE_PERFORMANCE";
            }
        }
        return "INVALID";
    }

    public int startRecording(int audioSource, int sampleRate, int channelCount, int frameSize) {
        this.mBytesPerFrame = channelCount * 2;
        this.mSampleRate = sampleRate;
        int n2 = channelCount == 1 ? 16 : 12;
        int n3 = AudioRecord.getMinBufferSize((int)sampleRate, (int)n2, (int)2);
        if (n3 <= 0) {
            Log.e(TAG, "AudioRecord.getMinBufferSize return error: ".concat(String.valueOf(n3)), new Object[0]);
        }
        if (n3 < sampleRate * channelCount) {
            n3 = sampleRate * channelCount;
        }
        int[] nArray = new int[]{audioSource, 1, 5, 0};
        for (int i2 = 0; i2 < 4 && this.mAudioRecord == null; ++i2) {
            int n4 = nArray[i2];
            for (int i3 = 1; i3 <= 2 && this.mAudioRecord == null; ++i3) {
                this.mBufferSize = n3 * i3;
                if (this.mBufferSize < frameSize * 4 && i3 < 2) continue;
                this.mAudioRecord = this.createStartedAudioRecord(n4, sampleRate, n2, this.mBufferSize);
            }
        }
        if (this.mAudioRecord == null) {
            return -1;
        }
        this.mSystemOSVersion = LiteavSystemInfo.getSystemOSVersionInt();
        Process.setThreadPriority((int)-19);
        return 0;
    }

    public int read(ByteBuffer buffer, int size) {
        if (this.mAudioRecord == null) {
            return -1;
        }
        buffer.position(0);
        int n2 = this.mAudioRecord.read(buffer, size);
        if (n2 < 0) {
            Log.e(TAG, "read failed, %d", n2);
            return -1;
        }
        this.mReadFrameIndex += n2 / this.mBytesPerFrame;
        return n2;
    }

    public void stopRecording() {
        LiteavAudioRecord3.destroyAudioRecord(this.mAudioRecord);
        this.mAudioRecord = null;
    }

    public int getSessionId() {
        if (this.mAudioRecord == null) {
            return -1;
        }
        return this.mAudioRecord.getAudioSessionId();
    }

    public int getRecordLatencyMs() {
        if (this.mAudioRecord == null) {
            return 30;
        }
        if (this.mSystemOSVersion < 24) {
            return 30;
        }
        int n2 = 30;
        try {
            n2 = this.getLatencyByTimestamp();
        }
        catch (Throwable throwable) {
            Log.w(TAG, "get latency exception " + throwable.getMessage(), new Object[0]);
        }
        return n2;
    }

    private int getLatencyByTimestamp() {
        AudioTimestamp audioTimestamp = new AudioTimestamp();
        if (this.mAudioRecord.getTimestamp(audioTimestamp, 0) != 0) {
            Log.w(TAG, "fail to get audio record timestamp", new Object[0]);
            return 30;
        }
        long l2 = (long)this.mReadFrameIndex - audioTimestamp.framePosition;
        long l3 = this.lengthBytesToNano(l2);
        long l4 = audioTimestamp.nanoTime + l3;
        int n2 = (int)((System.nanoTime() - l4) / 1000000L);
        int n3 = n2 + 20;
        if (n2 > 0 && (long)n2 <= 1000L) {
            return n3;
        }
        return 30;
    }

    private long lengthBytesToNano(long frameIndexDelta) {
        return frameIndexDelta * 1000000000L / (long)this.mSampleRate;
    }
}

