/*
 * Decompiled with CFR 0.152.
 */
package com.gme.liteav.base.networkbinder;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkRequest;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import com.gme.liteav.base.ContextUtils;
import com.gme.liteav.base.Log;
import com.gme.liteav.base.annotations.JNINamespace;
import com.gme.liteav.base.system.LiteavSystemInfo;
import com.gme.liteav.base.util.LiteavLog;
import java.io.FileDescriptor;

@JNINamespace(value="liteav")
public class NetworkBinder {
    private static final String TAG = "NetworkBinder";
    private static boolean isPrint = true;
    private final Object mLocker = new Object();
    private long mNativeNetworkBinderJni;
    private final Handler mHandler;
    private boolean mIsActivatingNetwork = false;
    private boolean mIsNetworkAvailable = false;
    private int mNetworkType = 0;
    public static final int DEFAULT = 0;
    public static final int WIFI = 1;
    public static final int CELLULAR = 2;
    private ConnectivityManager.NetworkCallback mNetworkCallback = null;
    private final Runnable mTimeoutRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Object object = NetworkBinder.this.mLocker;
            synchronized (object) {
                if (NetworkBinder.this.mIsActivatingNetwork && NetworkBinder.this.checkNativeValid()) {
                    NetworkBinder.nativeOnNetworkAvailable(NetworkBinder.this.mNativeNetworkBinderJni, "", false);
                    LiteavLog.e(NetworkBinder.TAG, "[BindSocket]:activate network timeout");
                    NetworkBinder.this.mIsActivatingNetwork = false;
                    NetworkBinder.this.mIsNetworkAvailable = false;
                    NetworkBinder.this.deactivateNetworkAdapter();
                }
                return;
            }
        }
    };

    public NetworkBinder(long nativeNetworkBinderJni) {
        this.mNativeNetworkBinderJni = nativeNetworkBinderJni;
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.mLocker;
        synchronized (object) {
            this.mIsActivatingNetwork = false;
            this.mIsNetworkAvailable = false;
            this.deactivateNetworkAdapter();
            this.cancleTimeoutRunnable();
            this.mNativeNetworkBinderJni = -1L;
            return;
        }
    }

    private void cancleTimeoutRunnable() {
        if (this.mHandler != null) {
            Log.i(TAG, "[BindSocket]:remove cancel last request network runnable", new Object[0]);
            this.mHandler.removeCallbacks(this.mTimeoutRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectivityManager.NetworkCallback createNetworkCallback() {
        Object object = this.mLocker;
        synchronized (object) {
            if (this.mNetworkCallback != null) {
                return this.mNetworkCallback;
            }
        }
        if (!NetworkBinder.checkSystemVersionValid()) {
            return null;
        }
        object = NetworkBinder.getConnectivityManager();
        if (object == null) {
            return null;
        }
        ConnectivityManager.NetworkCallback networkCallback = new ConnectivityManager.NetworkCallback((ConnectivityManager)object){
            final /* synthetic */ ConnectivityManager a;
            {
                this.a = connectivityManager;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void onAvailable(Network network) {
                super.onAvailable(network);
                if (network == null) {
                    Log.e(NetworkBinder.TAG, "[BindSocket]:onAvailable, network is null", new Object[0]);
                    return;
                }
                LinkProperties linkProperties = this.a.getLinkProperties(network);
                Object object = NetworkBinder.this.mLocker;
                synchronized (object) {
                    if (!NetworkBinder.this.mIsActivatingNetwork) {
                        return;
                    }
                    NetworkBinder.this.mIsActivatingNetwork = false;
                    NetworkBinder.this.mIsNetworkAvailable = true;
                    if (linkProperties != null && NetworkBinder.this.checkNativeValid()) {
                        String string = linkProperties.getInterfaceName();
                        NetworkBinder.nativeOnNetworkAvailable(NetworkBinder.this.mNativeNetworkBinderJni, string, true);
                        Log.i(NetworkBinder.TAG, "[BindSocket]:start network succ, network name=".concat(String.valueOf(string)), new Object[0]);
                    }
                    NetworkBinder.this.cancleTimeoutRunnable();
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void onLost(Network network) {
                super.onLost(network);
                Object object = NetworkBinder.this.mLocker;
                synchronized (object) {
                    if (!NetworkBinder.this.mIsNetworkAvailable || NetworkBinder.this.mIsActivatingNetwork) {
                        return;
                    }
                    NetworkBinder.this.mIsNetworkAvailable = false;
                    if (NetworkBinder.this.checkNativeValid()) {
                        NetworkBinder.nativeOnNetworkAvailable(NetworkBinder.this.mNativeNetworkBinderJni, "", false);
                        Log.i(NetworkBinder.TAG, "[BindSocket]:network onLost", new Object[0]);
                    }
                    NetworkBinder.this.deactivateNetworkAdapter();
                    return;
                }
            }
        };
        Object object2 = this.mLocker;
        synchronized (object2) {
            this.mNetworkCallback = networkCallback;
        }
        return networkCallback;
    }

    private static ConnectivityManager getConnectivityManager() {
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            return null;
        }
        return (ConnectivityManager)context.getSystemService("connectivity");
    }

    private static boolean checkSystemVersionValid() {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 23) {
            if (isPrint) {
                LiteavLog.e(TAG, "[BindSocket]:The android version is too low and does not support network binding");
                isPrint = false;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNativeValid() {
        Object object = this.mLocker;
        synchronized (object) {
            return this.mNativeNetworkBinderJni != -1L;
        }
    }

    public void resumeDefaultNetworkAdapter() {
        this.mNetworkType = 0;
        this.deactivateNetworkAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activateNetworkAdapter(int networkType) {
        block12: {
            if (networkType != 1 && networkType != 2) {
                return false;
            }
            try {
                Object object = this.mLocker;
                synchronized (object) {
                    if (this.mIsActivatingNetwork) {
                        LiteavLog.e(TAG, "[BindSocket]:mIsActivatingNetwork is true");
                        return false;
                    }
                    this.mIsActivatingNetwork = true;
                    this.mIsNetworkAvailable = false;
                    if (this.mNetworkType != networkType) {
                        this.deactivateNetworkAdapter();
                    }
                    this.mNetworkType = networkType;
                }
                if (!this.doActivateNetworkAdapter(networkType)) break block12;
                object = this.mLocker;
                synchronized (object) {
                    if (this.mHandler != null) {
                        this.mHandler.postDelayed(this.mTimeoutRunnable, 2000L);
                    }
                }
                return true;
            }
            catch (Exception exception) {
                LiteavLog.e(TAG, "[BindSocket]:activateNetworkAdapter in java encountered an exception, networkType:".concat(String.valueOf(networkType)));
            }
        }
        return false;
    }

    public boolean doActivateNetworkAdapter(int networkType) {
        int n2;
        if (networkType == 1) {
            n2 = 1;
        } else if (networkType == 2) {
            n2 = 0;
        } else {
            return false;
        }
        try {
            if (!NetworkBinder.checkSystemVersionValid()) {
                return false;
            }
            ConnectivityManager connectivityManager = NetworkBinder.getConnectivityManager();
            if (connectivityManager == null) {
                return false;
            }
            ConnectivityManager.NetworkCallback networkCallback = this.createNetworkCallback();
            if (networkCallback == null) {
                return false;
            }
            NetworkRequest networkRequest = new NetworkRequest.Builder().addCapability(12).addTransportType(n2).build();
            connectivityManager.requestNetwork(networkRequest, networkCallback);
            return true;
        }
        catch (Exception exception) {
            LiteavLog.e(TAG, "[BindSocket]:requestNetwork in java encountered an exception, networkType:".concat(String.valueOf(networkType)));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateNetworkAdapter() {
        try {
            if (!NetworkBinder.checkSystemVersionValid()) {
                return;
            }
            ConnectivityManager connectivityManager = NetworkBinder.getConnectivityManager();
            if (connectivityManager == null) {
                return;
            }
            Object object = this.mLocker;
            synchronized (object) {
                if (this.mNetworkCallback != null) {
                    Log.i(TAG, "[BindSocket]:deactivat network adapter", new Object[0]);
                    connectivityManager.unregisterNetworkCallback(this.mNetworkCallback);
                }
                return;
            }
        }
        catch (Exception exception) {
            LiteavLog.e(TAG, "[BindSocket]:deactivateNetworkAdapter in java encountered an exception");
            return;
        }
    }

    public static Network findNetwork(String interfaceName) {
        if (!NetworkBinder.checkSystemVersionValid()) {
            return null;
        }
        ConnectivityManager connectivityManager = NetworkBinder.getConnectivityManager();
        if (connectivityManager == null) {
            return null;
        }
        for (Network network : connectivityManager.getAllNetworks()) {
            LinkProperties linkProperties = connectivityManager.getLinkProperties(network);
            if (linkProperties == null || !linkProperties.getInterfaceName().equals(interfaceName)) continue;
            return network;
        }
        return null;
    }

    public static boolean bindSocket(String name, int socket) {
        if (name == null || name.isEmpty() || socket == -1) {
            return false;
        }
        try {
            if (!NetworkBinder.checkSystemVersionValid()) {
                return false;
            }
            Network network = NetworkBinder.findNetwork(name);
            if (network == null) {
                LiteavLog.e(TAG, "[BindSocket]:NetworkBinder bindSocket can not find network:".concat(String.valueOf(name)));
                return false;
            }
            FileDescriptor fileDescriptor = ParcelFileDescriptor.fromFd((int)socket).getFileDescriptor();
            network.bindSocket(fileDescriptor);
            LiteavLog.i(TAG, "[BindSocket]:NetworkBinder bindSocket succ, name:" + name + " socket:" + socket);
            return true;
        }
        catch (Exception exception) {
            LiteavLog.e(TAG, "[BindSocket]:bindSocket in java encountered an exception, name:" + name + " socket:" + socket);
            return false;
        }
    }

    private static native void nativeOnNetworkAvailable(long var0, String var2, boolean var3);
}

