/*
 * Decompiled with CFR 0.152.
 */
package com.gme.liteav.base.util;

import android.net.Uri;
import com.gme.liteav.base.ContextUtils;
import com.gme.liteav.base.Log;
import com.gme.liteav.base.annotations.JNINamespace;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

@JNINamespace(value="liteav")
public class UrlReader {
    private static final String TAG = "UrlReader";
    private static final int AVSEEK_SIZE = 65536;
    private static final int SEEK_SET = 0;
    private static final int SEEK_CUR = 1;
    private static final int SEEK_END = 2;
    private Uri mUri;
    private InputStream mStream;
    private int mFileSize;
    private long mOffset;

    public UrlReader(String uri) {
        this.mUri = Uri.parse((String)uri);
        this.open();
    }

    private void open() {
        try {
            this.mStream = ContextUtils.getApplicationContext().getContentResolver().openInputStream(this.mUri);
            this.mFileSize = this.mStream.available();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e(TAG, "Fail to open uri " + this.mUri.toString(), new Object[0]);
            this.mStream = null;
            return;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Fail to get file size " + iOException.getMessage(), new Object[0]);
            this.mStream = null;
            return;
        }
    }

    public int read(byte[] bytes, int size) {
        int n2 = -1;
        if (this.mStream == null) {
            return -1;
        }
        try {
            n2 = this.mStream.read(bytes, 0, size);
            this.mOffset += (long)n2;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Read exception " + iOException.getMessage(), new Object[0]);
        }
        return n2;
    }

    public long seek(long offset, int whence) {
        long l2 = -1L;
        if (this.mStream == null) {
            return -1L;
        }
        switch (whence) {
            case 65536: {
                l2 = this.mFileSize;
                break;
            }
            case 0: {
                l2 = this.seekFromBegin(offset);
                break;
            }
            case 1: {
                l2 = this.seekFromCurrent(offset);
                break;
            }
            case 2: {
                l2 = this.seekFromEnd(offset);
            }
        }
        return l2;
    }

    private long seekFromBegin(long offset) {
        long l2 = -1L;
        if (offset < 0L) {
            return -1L;
        }
        this.close();
        this.open();
        if (this.mStream == null) {
            return -1L;
        }
        try {
            l2 = this.mOffset = this.mStream.skip(offset);
        }
        catch (IOException iOException) {
            Log.e(TAG, "Fail to seek " + offset + " exception " + iOException.getMessage(), new Object[0]);
        }
        return l2;
    }

    private long seekFromCurrent(long offset) {
        if (offset < 0L) {
            UrlReader urlReader = this;
            return urlReader.seekFromBegin(urlReader.mOffset + offset);
        }
        long l2 = -1L;
        try {
            this.mOffset += this.mStream.skip(offset);
            l2 = this.mOffset;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Fail to seek " + offset + " exception " + iOException.getMessage(), new Object[0]);
        }
        return l2;
    }

    private long seekFromEnd(long offset) {
        long l2 = -1L;
        if (offset > 0L) {
            return -1L;
        }
        long l3 = (long)this.mFileSize + offset;
        if (l3 < 0L) {
            return -1L;
        }
        if (l3 < this.mOffset) {
            return this.seekFromBegin(l3);
        }
        long l4 = l3 - this.mOffset;
        try {
            this.mOffset += this.mStream.skip(l4);
            l2 = this.mOffset;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Fail to seek " + offset + " exception " + iOException.getMessage(), new Object[0]);
        }
        return l2;
    }

    public void close() {
        if (this.mStream != null) {
            try {
                this.mStream.close();
            }
            catch (IOException iOException) {
                Log.e(TAG, "Close exception " + iOException.getMessage(), new Object[0]);
            }
        }
        this.mStream = null;
        this.mOffset = 0L;
        this.mFileSize = 0;
    }
}

