/*
 * Decompiled with CFR 0.152.
 */
package com.gme.trtc.hardwareearmonitor;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.gme.liteav.base.ContextUtils;
import com.gme.liteav.base.annotations.JNINamespace;

@JNINamespace(value="liteav::extensions")
public class HardwareEarMonitorUtil
extends BroadcastReceiver {
    private long mNativeHardwareEarMonitorHandle = 0L;
    private int mHeadsetState = -1;
    private int mHasMicrophone = -1;
    private String mDeviceName = "NotDefine";
    private String mPortName = "NotDefine";
    private String mDeviceAddress = "NotDefine";
    private Context mContext;
    private IntentFilter mFilter;
    private Object mLock = new Object();

    public static HardwareEarMonitorUtil create(long nativeHardwareEarMonitorHandle) {
        return new HardwareEarMonitorUtil(nativeHardwareEarMonitorHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.mContext != null) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this);
        }
        if (this.mFilter != null) {
            this.mFilter = null;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mNativeHardwareEarMonitorHandle = 0L;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        String string = intent.getAction();
        if (!"android.intent.action.HEADSET_PLUG".equals(string)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mHeadsetState = intent.getIntExtra("state", -1);
            this.mHasMicrophone = intent.getIntExtra("microphone", -1);
            this.mDeviceName = intent.getStringExtra("device");
            this.mPortName = intent.getStringExtra("portName");
            this.mDeviceAddress = intent.getStringExtra("address");
            HardwareEarMonitorUtil.nativeHeadsetDescChanged(this.mNativeHardwareEarMonitorHandle, this.mHeadsetState, this.mHasMicrophone, this.mDeviceName == null ? "" : this.mDeviceName, this.mPortName == null ? "" : this.mPortName, this.mDeviceAddress == null ? "" : this.mDeviceAddress);
            return;
        }
    }

    public HardwareEarMonitorUtil(long nativeHardwareEarMonitorHandle) {
        this.mContext = ContextUtils.getApplicationContext();
        this.mNativeHardwareEarMonitorHandle = nativeHardwareEarMonitorHandle;
        try {
            this.mFilter = new IntentFilter("android.intent.action.HEADSET_PLUG");
            HardwareEarMonitorUtil hardwareEarMonitorUtil = this;
            this.mContext.registerReceiver((BroadcastReceiver)hardwareEarMonitorUtil, hardwareEarMonitorUtil.mFilter);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private static native void nativeHeadsetDescChanged(long var0, int var2, int var3, String var4, String var5, String var6);
}

