/*
 * Decompiled with CFR 0.152.
 */
package com.gme.trtc.hardwareearmonitor.daisy;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import com.gme.liteav.base.util.LiteavLog;
import com.gme.trtc.hardwareearmonitor.daisy.DaisyAudioFeaturesKit;
import com.gme.trtc.hardwareearmonitor.daisy.DaisyFeatureKitManager;
import com.gme.trtc.hardwareearmonitor.daisy.IDaisyAudioEngine;
import com.gme.trtc.hardwareearmonitor.daisy.IDaisyAudioKitCallback;
import java.util.ArrayList;
import java.util.List;

public class DaisyAudioKit {
    private static final String TAG = "DaisyAudioKit.DaisyAudioKit";
    private static final String ENGINE_CLASS_NAME = "com.huawei.multimedia.audioengine.HwAudioEngineService";
    private static final List<Integer> DEFAULT_FEATURE_LIST = new ArrayList<Integer>(0);
    private Context mContext = null;
    private IDaisyAudioEngine mIHwAudioEngine = null;
    private boolean mIsServiceConnected = false;
    private DaisyFeatureKitManager mFeatureKitManager;
    private IBinder mService = null;
    private ServiceConnection mConnection = new ServiceConnection(){

        public final void onServiceConnected(ComponentName name, IBinder service) {
            DaisyAudioKit.this.mIHwAudioEngine = IDaisyAudioEngine.Stub.asInterface(service);
            if (DaisyAudioKit.this.mIHwAudioEngine != null) {
                DaisyAudioKit.this.mIsServiceConnected = true;
                DaisyAudioKit.this.mFeatureKitManager.onCallBack(0);
                DaisyAudioKit.this.serviceInit(DaisyAudioKit.this.mContext.getPackageName(), "1.0.1");
                DaisyAudioKit.this.serviceLinkToDeath(service);
            }
        }

        public final void onServiceDisconnected(ComponentName name) {
            DaisyAudioKit.this.mIHwAudioEngine = null;
            DaisyAudioKit.this.mIsServiceConnected = false;
            DaisyAudioKit.this.mFeatureKitManager.onCallBack(4);
        }
    };
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        public final void binderDied() {
            DaisyAudioKit.this.mService.unlinkToDeath(DaisyAudioKit.this.mDeathRecipient, 0);
            DaisyAudioKit.this.mFeatureKitManager.onCallBack(6);
            LiteavLog.e(DaisyAudioKit.TAG, "service binder died");
            DaisyAudioKit.this.mService = null;
        }
    };

    public DaisyAudioKit(Context context, IDaisyAudioKitCallback callback) {
        this.mFeatureKitManager = DaisyFeatureKitManager.getInstance();
        this.mFeatureKitManager.setCallBack(callback);
        this.mContext = context;
    }

    private void serviceLinkToDeath(IBinder service) {
        this.mService = service;
        try {
            if (this.mService != null) {
                this.mService.linkToDeath(this.mDeathRecipient, 0);
            }
            return;
        }
        catch (Throwable throwable) {
            this.mFeatureKitManager.onCallBack(5);
            LiteavLog.e(TAG, "serviceLinkToDeath, RemoteException");
            return;
        }
    }

    public void initialize() {
        if (this.mContext == null) {
            this.mFeatureKitManager.onCallBack(7);
            return;
        }
        if (!DaisyFeatureKitManager.isAudioKitSupport(this.mContext)) {
            this.mFeatureKitManager.onCallBack(2);
            return;
        }
        DaisyAudioKit daisyAudioKit = this;
        daisyAudioKit.bindService(daisyAudioKit.mContext);
    }

    private void bindService(Context context) {
        try {
            if (this.mFeatureKitManager != null && !this.mIsServiceConnected) {
                this.mFeatureKitManager.bindService(context, this.mConnection, ENGINE_CLASS_NAME);
            }
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "bindService,RemoteException ex : %s", throwable.getMessage());
            return;
        }
    }

    public void destroy() {
        try {
            if (this.mIsServiceConnected) {
                this.mIsServiceConnected = false;
                this.mFeatureKitManager.unbindService(this.mContext, this.mConnection);
            }
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "unbindService,RemoteException ex : %s", throwable.getMessage());
            return;
        }
    }

    public List<Integer> getSupportedFeatures() {
        try {
            if (this.mIHwAudioEngine != null && this.mIsServiceConnected) {
                return this.mIHwAudioEngine.getSupportedFeatures();
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "getSupportedFeatures, createFeature,wait bind service fail");
        }
        return DEFAULT_FEATURE_LIST;
    }

    public boolean isFeatureSupported(FeatureType type) {
        if (type == null) {
            return false;
        }
        try {
            if (this.mIHwAudioEngine != null && this.mIsServiceConnected) {
                return this.mIHwAudioEngine.isFeatureSupported(type.getFeatureType());
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "isFeatureSupported,RemoteException ex : %s", throwable.getMessage());
        }
        return false;
    }

    public <T extends DaisyAudioFeaturesKit> T createFeature(FeatureType type) {
        if (this.mFeatureKitManager != null && type != null) {
            return this.mFeatureKitManager.createFeatureKit(type.getFeatureType(), this.mContext);
        }
        return null;
    }

    private void serviceInit(String packageName, String sdkVersion) {
        try {
            if (this.mIHwAudioEngine != null && this.mIsServiceConnected) {
                this.mIHwAudioEngine.init(packageName, sdkVersion);
            }
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "isFeatureSupported,RemoteException ex : %s", throwable.getMessage());
            return;
        }
    }

    public static enum FeatureType {
        HWAUDIO_FEATURE_KARAOKE(1);

        private int mFeatureType;

        private FeatureType(int type) {
            this.mFeatureType = type;
        }

        public final int getFeatureType() {
            return this.mFeatureType;
        }
    }
}

