/*
 * Decompiled with CFR 0.152.
 */
package com.gme.trtc.hardwareearmonitor.honor;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import com.gme.trtc.hardwareearmonitor.honor.HonorAudioFeaturesKit;
import com.gme.trtc.hardwareearmonitor.honor.HonorFeatureKitManager;
import com.gme.trtc.hardwareearmonitor.honor.HonorLogUtils;
import com.gme.trtc.hardwareearmonitor.honor.IHonorAudioService;
import com.gme.trtc.hardwareearmonitor.honor.IHonorAudioServiceCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class HonorAudioClient {
    private static final String TAG = "HnAudioEngine.HnAudioClient";
    private static final String ENGINE_CLASS_NAME = "com.hihonor.android.magicx.media.audioengine.HnAudioServiceImpl";
    private static final String ENGINE_PACKAGE_NAME = "com.hihonor.android.magicx.media.audioengine";
    private static final int DEFAULT_VALUE = 0;
    private static final List<Integer> DEFAULT_FEATURE_LIST = new ArrayList<Integer>(0);
    private Context mContext = null;
    private IHonorAudioService mIHnAudioService = null;
    private boolean mIsServiceConnected = false;
    private IBinder mService = null;
    private List<Integer> mSupportedServiceList = new ArrayList<Integer>();
    private ServiceConnection mConnection = new ServiceConnection(){

        public final void onServiceConnected(ComponentName name, IBinder service) {
            HonorAudioClient.this.mIHnAudioService = IHonorAudioService.Stub.asInterface(service);
            HonorLogUtils.info(HonorAudioClient.TAG, "onServiceConnected");
            if (HonorAudioClient.this.mIHnAudioService != null) {
                HonorAudioClient.this.mIsServiceConnected = true;
                HonorLogUtils.info(HonorAudioClient.TAG, "onServiceConnected, mIHnAudioService is not null");
                HonorAudioClient.this.mFeatureKitManager.onCallBack(0);
                HonorAudioClient.this.serviceInit(HonorAudioClient.this.mContext.getPackageName(), "1.0.1.300");
                HonorAudioClient.this.serviceLinkToDeath(service);
            }
        }

        public final void onServiceDisconnected(ComponentName name) {
            HonorLogUtils.info(HonorAudioClient.TAG, "onServiceDisconnected");
            HonorAudioClient.this.mIHnAudioService = null;
            HonorAudioClient.this.mIsServiceConnected = false;
            HonorAudioClient.this.mFeatureKitManager.onCallBack(4);
        }
    };
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        public final void binderDied() {
            HonorAudioClient.this.mService.unlinkToDeath(HonorAudioClient.this.mDeathRecipient, 0);
            HonorAudioClient.this.mFeatureKitManager.onCallBack(6);
            HonorLogUtils.error(HonorAudioClient.TAG, "service binder died");
            HonorAudioClient.this.mService = null;
        }
    };
    private HonorFeatureKitManager mFeatureKitManager = HonorFeatureKitManager.getInstance();

    public HonorAudioClient(Context context, IHonorAudioServiceCallback callback) {
        this.mFeatureKitManager.setCallBack(callback);
        this.mContext = context;
    }

    private void serviceLinkToDeath(IBinder service) {
        this.mService = service;
        try {
            if (this.mService != null) {
                this.mService.linkToDeath(this.mDeathRecipient, 0);
            }
            return;
        }
        catch (Throwable throwable) {
            this.mFeatureKitManager.onCallBack(5);
            HonorLogUtils.error(TAG, "serviceLinkToDeath, RemoteException");
            return;
        }
    }

    public void initialize() {
        HonorLogUtils.info(TAG, "initialize");
        if (this.mContext == null) {
            HonorLogUtils.info(TAG, "mContext is null");
            this.mFeatureKitManager.onCallBack(7);
            return;
        }
        if (!HonorFeatureKitManager.isAudioKitSupport(this.mContext)) {
            HonorLogUtils.info(TAG, "not install AudioKitEngine");
            this.mFeatureKitManager.onCallBack(2);
            return;
        }
        HonorAudioClient honorAudioClient = this;
        honorAudioClient.bindService(honorAudioClient.mContext);
    }

    private void bindService(Context context) {
        HonorLogUtils.info(TAG, "bindService, mIsServiceConnected = " + this.mIsServiceConnected);
        try {
            if (this.mFeatureKitManager != null && !this.mIsServiceConnected) {
                this.mFeatureKitManager.bindService(context, this.mConnection, ENGINE_CLASS_NAME);
            }
            return;
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "bindService,RemoteException ex : " + throwable.getMessage());
            return;
        }
    }

    public void destroy() {
        HonorLogUtils.info(TAG, "destroy, mIsServiceConnected = " + this.mIsServiceConnected);
        try {
            if (this.mIsServiceConnected) {
                this.mIsServiceConnected = false;
                this.mFeatureKitManager.unbindService(this.mContext, this.mConnection);
            }
            return;
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "unbindService,RemoteException ex : " + throwable.getMessage());
            return;
        }
    }

    public static boolean isDeviceSupported(Context context) {
        return HonorFeatureKitManager.isAudioKitSupport(context);
    }

    public List<Integer> getSupportedServices() {
        try {
            if (this.mIHnAudioService != null && this.mIsServiceConnected) {
                List list = this.mIHnAudioService.getSupportedServices();
                if (list == null) {
                    HonorLogUtils.error(TAG, "list is null");
                    return DEFAULT_FEATURE_LIST;
                }
                this.mSupportedServiceList.clear();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    this.filterUnsupportedService(n2);
                }
                HonorLogUtils.info(TAG, "getSupportedServices " + Arrays.toString(list.toArray()));
                return this.mSupportedServiceList;
            }
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "getSupportedServices, createFeature,wait bind service fail");
        }
        HonorLogUtils.info(TAG, "getSupportedServices, service not bind");
        return DEFAULT_FEATURE_LIST;
    }

    private void filterUnsupportedService(int type) {
        switch (type) {
            case 1: {
                if (HonorFeatureKitManager.mMinVersion >= 1000000L) {
                    this.mSupportedServiceList.add(type);
                    return;
                }
                return;
            }
            case 2: {
                if (HonorFeatureKitManager.mMinVersion >= 1000000L) {
                    this.mSupportedServiceList.add(type);
                    return;
                }
                return;
            }
            case 3: {
                if (HonorFeatureKitManager.mMinVersion >= 1000001L) {
                    this.mSupportedServiceList.add(type);
                    return;
                }
                return;
            }
            case 4: {
                if (HonorFeatureKitManager.mMinVersion >= 1000001L) {
                    this.mSupportedServiceList.add(type);
                    return;
                }
                return;
            }
        }
    }

    public boolean isServiceSupported(ServiceType type) {
        if (type == null) {
            return false;
        }
        HonorLogUtils.info(TAG, "isServiceSupported, type = " + type.getServiceType());
        try {
            if (this.mIHnAudioService != null && this.mIsServiceConnected && this.mSupportedServiceList.contains(type.getServiceType())) {
                return this.mIHnAudioService.isServiceSupported(type.getServiceType());
            }
            return false;
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "isServiceSupported,RemoteException ex : " + throwable.getMessage());
            return false;
        }
    }

    public <T extends HonorAudioFeaturesKit> T createService(ServiceType serviceType) {
        if (this.mFeatureKitManager != null && serviceType != null && this.mSupportedServiceList.contains(serviceType.getServiceType())) {
            return this.mFeatureKitManager.createFeatureKit(serviceType.getServiceType(), this.mContext);
        }
        HonorLogUtils.error(TAG, "createService fail");
        return null;
    }

    private void serviceInit(String packageName, String sdkVersion) {
        HonorLogUtils.info(TAG, "serviceInit");
        try {
            if (this.mIHnAudioService != null && this.mIsServiceConnected) {
                this.mIHnAudioService.init(packageName, sdkVersion);
            }
            return;
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "isFeatureSupported,RemoteException ex :" + throwable.getMessage());
            return;
        }
    }

    public static enum ServiceType {
        HNAUDIO_SERVICE_EARRETURN(1),
        HNAUDIO_SERVICE_ADVANCEDRECORD(2),
        HNAUDIO_SERVICE_HIGHSAMPLERATEPLAY(3),
        HNAUDIO_SERVICE_RECORDDENOISE(4);

        private int mServiceType;

        private ServiceType(int type) {
            this.mServiceType = type;
        }

        public final int getServiceType() {
            return this.mServiceType;
        }
    }
}

