#include "ChatRoom/CsdkJoinChatRoom.h"
#include "Tools/CsdkCommonTools.h"

UCsdkJoinChatRoom* UCsdkJoinChatRoom::JoinChatRoom(UObject* WorldContextObject, const FCsdkChatRoomId& RoomId)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkJoinChatRoom* Action = NewObject<UCsdkJoinChatRoom>();
	Action->ChatRoomId = RoomId;
	Action->RegisterWithGameInstance(WorldContextObject);
	return Action;
}

void UCsdkJoinChatRoom::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetChatRoomManager().JoinChatRoom(ChatRoomId,
	[this](const int32 ErrorCode,const FString& ErrorMsg,const FCsdkChatRoomInfo& ChatRoomInfo)
	{
		if(!this->IsValidLowLevel())
			return;
		
		this->Completed.Broadcast(ErrorCode,ErrorMsg,ChatRoomInfo);
		this->SetReadyToDestroy();
	});
}

