﻿#pragma once
#include "ChatRoom/Data/ChatRoomEventType.h"
#include "ChatRoom/Data/CsdkChatRoomInfo.h"
#include "User/Data/CsdkUserOperateResult.h"

class FChatRoomManager
{
public:
	void Reset();
	void CreateChatRoom(const FCsdkChatRoomId& UniqueId,const FCsdkChatRoomCreateParam& CreateParam,
		const TFunction<void(const int32 ErrorCode,const FString& ErrorMsg,const FCsdkChatRoomInfo& ChatRoomInfo)>&  Callback);
	void JoinChatRoom(const FCsdkChatRoomId& Id,
		const TFunction<void(const int32 ErrorCode,const FString& ErrorMsg,const FCsdkChatRoomInfo& ChatRoomInfo)>& Callback = nullptr);
	void JoinAutoCreateChatRoom(const FCsdkChatRoomId& Id,const FCsdkChatRoomCreateParam& Param,
		const TFunction<void(const int32 ErrorCode,const FString& ErrorMsg,const FCsdkChatRoomInfo& ChatRoomInfo)>& Callback);
	void QuitChatRoom(const FCsdkChatRoomId& Id,const TFunction<void(const int32 ErrorCode,const FString& ErrorMsg)>& Callback);
	void DissolveChatRoom(const FCsdkChatRoomId& Id,const TFunction<void(const int32 ErrorCode,const FString& ErrorMsg)>& Callback);
	//@todo
	void InviteToChatRoom(const FCsdkChatRoomId& Id,const TSet<FCsdkUserId>& UserIds,
		const TFunction<void(const int32 ErrorCode,const FString& ErrorMsg)>& Callback);
	void RemoveChatRoomUser(const FCsdkChatRoomId& Id,const TSet<FCsdkUserId>& UserIds,
		const TFunction<void(const int32 ErrorCode,const FString& ErrorMsg, const TArray<FCsdkUserOperateResult>& OperateResult)>& Callback);

	bool GetChatRoomInfoById(const FCsdkChatRoomId& Id, FCsdkChatRoomInfo& ChatRoomInfo) const;
	TArray<FCsdkChatRoomInfo> GetChatRoomsInfo() const;
	void OnEventRecived(const EChatRoomEventType EventType,const FString& JsonData);
private:
	void JoinChatRoomRemote(const FCsdkChatRoomId& Id,
		const TFunction<void(const int32 ErrorCode,const FString& ErrorMsg,const FCsdkChatRoomInfo& ChatRoomInfo)>& Callback = nullptr);
	void JoinAutoCreateChatRoomRemote(const FCsdkChatRoomId& Id,const FCsdkChatRoomCreateParam& Param,
			const TFunction<void(const int32 ErrorCode,const FString& ErrorMsg,const FCsdkChatRoomInfo& ChatRoomInfo)>& Callback);
	void OnEventJoin(const FString& JsonData);
	void OnEventJoin(const FCsdkChatRoomInfo& RoomInfo);
	void OnEventMemberRemoved(const FString& JsonData);
	void OnEventDismissed(const FString& JsonData);
private:
	TMap<FCsdkChatRoomId,FCsdkChatRoomInfo> ChatRoomMap;
	
};
