﻿#include "Consensus/CsdkSensitiveTextCheck.h"
#include "Tools/CsdkCommonTools.h"

UCsdkSensitiveTextCheck* UCsdkSensitiveTextCheck::SensitiveTextCheck(UObject* WorldContextObject, const FString& Text, const FCsdkSensitiveTextCheckParam& ReportParam)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::IsInit(),TEXT("CSDK may not Init"))
#endif
	UCsdkSensitiveTextCheck* Action = NewObject<UCsdkSensitiveTextCheck>();
	Action->RegisterWithGameInstance(WorldContextObject);
	Action->SourceText = Text;
	Action->ReportToHeroParam = ReportParam;
	return Action;
}

void UCsdkSensitiveTextCheck::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetConsensusManager().SensitiveTextCheck(SourceText, ReportToHeroParam,
	[this](const int32 ErrorCode,const FString& ErrorMsg, const bool bPassed, const TArray<FString>& SensitiveWords)
	{
		if(!this->IsValidLowLevel())
			return;
		
		this->Completed.Broadcast(ErrorCode, ErrorMsg, bPassed, SensitiveWords);
		this->SetReadyToDestroy();
	});
}

