#include "CsdkNotify.h"
#include "Common/CsdkStringConvert.h"
#include "Manager/CsdkManager.h"
#include "message/model/message_model.pb.h"
#include "message/model/operation.pb.h"
#include "Relationship/Friend/Data/RelationshipEventType.h"
#include "Tools/CsdkCommonTools.h"
#include "Tools/Parser/ApiResult.h"
#include "message/Data/MessageEventType.h"

using heroim::client::v3beta::dto::message::model::Notify;

void FCsdkNotify::SysNotify(const TArray<uint8>& Data)
{

	if(!FCsdkCommonTools::IsAlive())
		return;

	const Notify PbNotify =TApiResult<Notify>::ParseT(Data);
	const FString JsonStr =STD_STRING_TO_FSTRING(PbNotify.data());
	const std::string EventType = PbNotify.eventtype();
	// 关系链
	if(EventType == "HTE:RSFriendAdd")
	{
		FCsdkCommonTools::GetFriendManager().OnEventReceived(ERelationshipEventType::FriendApplied, JsonStr);
	}
	else if(EventType == "HTE:RSFriendAdded")
	{
		FCsdkCommonTools::GetFriendManager().OnEventReceived(ERelationshipEventType::FriendAdded, JsonStr);
	}
	else if(EventType == "HTE:RSFriendDeleted")
	{
		FCsdkCommonTools::GetFriendManager().OnEventReceived(ERelationshipEventType::FriendDeleted, JsonStr);
	}
	//聊天室
	//用不上的接口
	/*else if(EventType == "HTE:GroupJoinApply")
	{
		FCsdkCommonTools::GetChatRoomManager()->OnEventRecived(EChatRoomEventType::JoinApply,JsonStr);
	}
	else if(EventType == "HTE:GroupJoinInvite")
	{
		FCsdkCommonTools::GetChatRoomManager()->OnEventRecived(EChatRoomEventType::JoinInvite,JsonStr);
	}
	else if(EventType == "HTE:GroupQuited")
	{
		FCsdkCommonTools::GetChatRoomManager()->OnEventRecived(EChatRoomEventType::Quited,JsonStr);
	}*/
	//聊天室事件
	else if(EventType == "HTE:GroupJoined")
	{
		FCsdkCommonTools::GetChatRoomManager().OnEventRecived(EChatRoomEventType::Join,JsonStr);
	}
	else if(EventType == "HTE:GroupMemberRemoved")
	{
		FCsdkCommonTools::GetChatRoomManager().OnEventRecived(EChatRoomEventType::MemberRemoved,JsonStr);
	}
	else if(EventType == "HTE:GroupDismissed")
	{
		FCsdkCommonTools::GetChatRoomManager().OnEventRecived(EChatRoomEventType::Dismissed,JsonStr);
	}
	//用户事件
	else if(EventType == "HTE:UserProfileChanged")
	{
		FCsdkCommonTools::GetUserManager().OnEventReceived(EUserEventType::UserProfileChanged, JsonStr);
	}
	else if(EventType == "HTE:UserStatusChanged")
	{
		FCsdkCommonTools::GetUserManager().OnEventReceived(EUserEventType::UserStatusChanged,JsonStr);
	}
	else if(EventType == "HTE:UserControlChanged")
	{
		FCsdkCommonTools::GetUserManager().OnEventReceived(EUserEventType::UserControlChanged,JsonStr);
	}
	else if(EventType == "HTE:MessageFlushChannel")
	{
		FCsdkCommonTools::GetMessageManager().OnEventReceived(EMessageEventType::ClearSessionMsg,JsonStr);
	}
	/*else if(EventType == "HTE:UserConnected")
	{
		FCsdkCommonTools::GetUserManager()->OnEventReceived(EUserEventType::UserConnected,JsonStr);
	}
	else if(EventType == "HTE:UserDisconnected")
	{
		FCsdkCommonTools::GetUserManager()->OnEventReceived(EUserEventType::UserDisconnected,JsonStr);
	}*/
}
