// Fill out your copyright notice in the Description page of Project Settings.


#include "Init/CsdkInitAction.h"
#include "Tools/CsdkCommonTools.h"
#include "Manager/InitManager.h"

UCsdkInitAction* UCsdkInitAction::CsdkInit(UObject* WorldContextObject,const FString& ProductId,const FString& ProductKey,const FString& Url)
{
#if UE_SERVER	
	return {};
#endif
	UCsdkInitAction* Action = NewObject<UCsdkInitAction>();
	Action->ProductId = ProductId;
	Action->ProductKey = ProductKey;
	Action->Url = Url;
	Action->RegisterWithGameInstance(WorldContextObject);
	return Action;
}

void UCsdkInitAction::CsdkDeinit()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetInitManager().DeInit();
}

void UCsdkInitAction::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetInitManager().Init(ProductId,ProductKey,Url, [this](const int32 ErrorCode, const FString ErrorMsg)
	{
		if(!this->IsValidLowLevel())
			return;
		
		Completed.Broadcast(ErrorCode,ErrorMsg);
		SetReadyToDestroy();
	});
}
