// Fill out your copyright notice in the Description page of Project Settings.


#include "CsdkTrace.h"


void CsdkTrace::AddOutput(const TSharedPtr<ICsdkTraceOutput>& Output)
{
	OutputArray.Add(Output);
}

void CsdkTrace::SetTraceLevel(ELogVerbosity::Type Level)
{
	LogLevel = Level;
}

void CsdkTrace::Log(const FName& Category, ELogVerbosity::Type Verbosity, const FString& Data)
{
	if(Verbosity<= LogLevel )
	{
		for (const auto& OutPut : OutputArray)
		{
			OutPut->Log(Category,Verbosity,Data);
		}
	}
}
