// Fill out your copyright notice in the Description page of Project Settings.


#include "CsdkTraceOutputFile.h"
#include "Misc/App.h"
#include "../../Output/Local/CsdkOutputDeviceFile.h"

CsdkTraceOutputFile::CsdkTraceOutputFile()
{
	FString FileName =FString::Printf(TEXT("%s_CSDK.log"),FApp::GetProjectName());
	FString CsdkLogPath =FPaths::Combine(FPaths::ProjectSavedDir(),TEXT("Csdk"),TEXT("CsdkLogs"),FileName);
	OutputDeviceFile = MakeUnique<FCsdkOutputDeviceFile>(*CsdkLogPath);
}

CsdkTraceOutputFile::~CsdkTraceOutputFile()
{
	OutputDeviceFile.Reset();
}

void CsdkTraceOutputFile::Log(const FName& Category, ELogVerbosity::Type Verbosity, const FString& Data)
{
	OutputDeviceFile->Log(Category,Verbosity,Data);
}
