
#pragma once

#include "LogUploader.h"
#include "Tickable.h"
#include "Tools/CsdkCommonHttp.h"

DECLARE_LOG_CATEGORY_EXTERN(LogCsdkLogs, Log, All);

class FLogForwarder : public FTickableGameObject
{
public:
	FLogForwarder(const FString& DeviceId);
	~FLogForwarder();
	
    void Tick(float DeltaTime) override;
    bool IsTickable() const override { return true; }

    TStatId GetStatId() const override;

	void Log(const FName& Category, ELogVerbosity::Type Verbosity, const FString& Data);

    void FlushLogs();
	TSharedPtr<FLogUploader> LogUploaderRunnable;
private:
	FString DeviceUniqueId;
    TArray<FLogItem> pendingLogs;
    float flushLogsInSeconds = FLT_MAX;
};
