﻿
#include "AuthCodeLoginState.h"
#include "auth/auth_dto.pb.h"
#include "Common/CsdkStringConvert.h"
#include "Tools/CsdkCommonTools.h"
#include "Log/CsdkLogMacros.h"
#include "Log/LogChatSdk.h"
#include "Tools/CsdkCommonHttp.h"

using namespace heroim::client::v3beta::dto::auth;

void FAuthCodeLoginState::Enter()
{
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::IsInit(),TEXT("System may not Init"));
#endif
	
	AuthCodeLoginRequest LoginRequest;
	LoginRequest.set_allocated_base(FCsdkCommonTools::MakePbBase());
	LoginRequest.set_authcode( FSTRING_TO_STD_STRING(AuthCode));

	CSDK_LOG(LogChatSdk,Log,TEXT("Enter Token LoginState with AuthCode:%s"),*AuthCode);


	auto selfWeak = this->AsWeak();
	auto CallBack =[selfWeak](const int32 ErrorCode,const FString& ErrorMsg,const LoginResponse& Resp)
	{
		if(selfWeak.IsValid())
		{
			const auto This = StaticCastSharedRef<FLoginStateBase>(selfWeak.Pin().ToSharedRef());
			This->HttpCallback(ErrorCode,ErrorMsg,Resp);
		}
		
	};
	FCsdkCommonHttp<LoginResponse>::Request(TEXT("/spi/v3beta/auth/login/code"),LoginRequest,CallBack);
	
}
