﻿#include "FLoginStateBase.h"

#include "Common/CsdkErrorCode.h"
#include "Tools/CsdkCommonTools.h"
#include "User/Tool/UserTool.h"


void FLoginStateBase::HttpCallback(const int32 ErrorCode,const FString& ErrorMsg,const heroim::client::v3beta::dto::auth::LoginResponse& Resp) const
{
	if(ErrorCode == ECsdkErrorCode::Success)
	{
		FCsdkCommonTools::GetUserManager().SetCurrentUser(CsdkUserTool::ConvertUser(Resp.user()));
		Manager.Token = (STD_STRING_TO_FSTRING(Resp.token()));
		FCsdkCommonTools::GetSessionManager().Init();
		FCsdkCommonTools::GetFriendManager().Init();
		FCsdkCommonTools::GetBlockManager().Init();
		
		SwitchState(ELoginStateId::Link);
	}
	else
	{
		CallLoginCallback(ErrorCode, ErrorMsg);
	}
}
