﻿#include "LinkState.h"
#include "Log/CsdkLogMacros.h"
#include "Log/LogChatSdk.h"
#include "../WebSocketConnection.h"
#include "Tools/CsdkCommonTools.h"

void FLinkState::Enter()
{
	if(WebSocketConnection->IsConnected())
	{
		CSDK_LOG(LogChatSdk,Error,TEXT("Link While Already connected"))
		WebSocketConnection->Close();
	}
	WebSocketConnection->CreateWebSocket(FCsdkCommonTools::GetWsAddress(),"ws");
	WebSocketConnection->OnConnectedEvent.BindRaw(&Manager,&FLoginManager::OnConnect);
	WebSocketConnection->OnConnectionErrorEvent.BindRaw(&Manager,&FLoginManager::OnConnectionError);
	WebSocketConnection->OnRawMsgRecvEvent.BindRaw(&Manager,&FLoginManager::OnRawMsgRecvEvent);
	WebSocketConnection->OnCloseEvent.BindRaw(&Manager,&FLoginManager::OnWebSocketClosed);
	WebSocketConnection->Connect();
	CSDK_LOG(LogChatSdk,Log,TEXT("Enter LinkState With Address %s"),*FCsdkCommonTools::GetWsAddress());
}


